package MCollection;
use strict;
use vars qw($AUTOLOAD);

=head1 MCollection

This is a simple utility class for mpMUD. It implements a collection of objects, and
allows you to call methods for all of the objects at once.

Usage:

  my $collection = MCollection->new($some, $thingies, @and, $stuff);
  $collection->do_something($arg,$um,$en,$ts);

Calling a method except new() does not currently return anything, but that may change
in the future.

=cut

sub new {
  my $class = shift;
  my $self = bless [@_], $class;
  return $self;
}

sub AUTOLOAD {
  my $self = shift;
  my ($method) = $AUTOLOAD =~ /::([^:]+)$/;
  foreach my $thing (@$self) {
    $thing->$method(@_);
  }
  return;
}

1;
