BEGIN {print "mpMUD starting up...\n"}
use constant GC_DEBUG => 0;

use strict;
use vars qw(
  %Rooms
  %Texts
  %Help %ImmHelp
  %DirtyFiles
  $NiceQuit
);
use lib 'engine';
use MCoreTools;
use MObject;
use MLoaders;
use MScheduler;
use MConnection;
use MConnection::Telnet;
use MZonedHash::Rooms;
use MBootstrap;

### Initialization ############################################################################################

$SIG{'INT'} = sub {MScheduler->stop; $NiceQuit = -1};

MCoreTools->open_log;
MLoaders->load_texts;
MConnection->listen_start;
MLoaders->load_stuff;
tie %Rooms, 'MZonedHash::Rooms';

MBootstrap->startup_checks;

### Main loop ############################################################################################

MScheduler->run;

$NiceQuit = 1 unless $NiceQuit;
exit;

### Cleanup ###############################################################################################

END {
  unless ($NiceQuit) {
    mudlog "Exiting due to crash.";
    MConnection->all->send("   *** Sorry, but $Texts{name} just crashed. ***");
    $? = 1;
  } elsif ($NiceQuit == -1) {
    mudlog "Exiting due to signal.";          
    MConnection->all->send("   *** $Texts{name} is shutting down. ***");
    $? = 1;    
  } else {
    mudlog "Exiting nicely.";
    MConnection->all->send("   *** $Texts{name} is shutting down. ***");
    $? = 0;
  }
  mudlog "Closing listener...";
  MConnection->listen_stop;
  mudlog "Destroying world...";
  MObject->all_do(sub { $_[0]->dispose; });
  mudlog "Exit cleanup complete."
}

__END__
