#
# The proper pronunciation is "hekstats".
#

MObject->ModFields (
  str => {default => 10},
 'int'=> {default => 10},
  wis => {default => 10},
  dex => {default => 10},
  con => {default => 10},
  cha => {default => 10},
);

MObject->ModMethods (
random_hextats => sub {
  my ($self) = @_;

  for my $field (qw(str int wis dex con cha)) {
    $self->set_val($field, dice(3, 6));
  }
},
);

MObject->Commands (
'@reroll' => {
  requires => [qw(nonplayer)],
  code => sub {
    my ($self, $args) = @_;
    $self->edit_target_obj->random_hextats;
    $self->send($self->edit_target_obj->name . "'s hextats rerolled.");
  },
  help => <<'EOHELP',
@reroll (re)generates random hextats for the currently selected object.
EOHELP
},
'@unroll' => {
  requires => [qw(nonplayer)],
  code => sub {
    my ($self, $args) = @_;
    my $obj = $self->edit_target_obj;
    $obj->ispc and do {
      $self->send("You shouldn't delete a PC's hextats; do it yourself if you really need to!");
      return;
    };
    for my $field (qw(str int wis dex con cha)) {
      $obj->reset_val($field);
    }
    $self->send($obj->name . "'s hextats deleted.");
  },
  help => <<'EOHELP',
@unroll deletes the hextat fields for the currently selected object. Useful if you accidentally did a @reroll. Cannot be used on PCs.
EOHELP
},
);

MLoaders->Hooks (
new_unique_setup => sub {
  $_[0]->random_hextats;
}
);