Require 'core', 'output';

Define Fields => {
  can_speak => {default => 0},
};

Define Commands => {
#---------------------------------------------------------------------------------------------------
  say    => {no_parse_args => 1, code => sub {$_[0]->speak(cargs => [@_], range => 4,    label => 'says')}, aliases => [qw(' " ask exclaim)], help => 'Says something to the people near you.'},
# shout  => {no_parse_args => 1, code => sub {$_[0]->speak(cargs => [@_], range => 30,   label => 'shouts')}},
# holler => {no_parse_args => 1, code => sub {$_[0]->speak(cargs => [@_], range => 1000, label => 'hollers')}},
  whine  => {no_parse_args => 1, code => sub {$_[0]->speak(cargs => [@_], range => 4.5,  label => 'whines')}},
  mutter => {no_parse_args => 1, code => sub {$_[0]->speak(cargs => [@_], range => 1.5,  label => 'mutters')}},
#---------------------------------------------------------------------------------------------------
emote => {
  aliases => [qw(: me ;)],
  no_options => 1,
  no_parse_args => 1,
  code => sub {
    my ($self, $args) = @_;
    $args or $self->send("Emote what?"), return;
    $args =~ s/([^!?.])$/$1./;
    $args =~ s/^(?=[\w(])/ /;
    $self->sact([action=>{},
      [if=>{},
        [test=>{}, [obj=>{part=>'vis'}, $self]],
        [then=>{}, [ucfirst=>{}, $self->nphr, [user=>{}, $args]]],
      ],
    ]);
    return;
  },
},
#---------------------------------------------------------------------------------------------------
echo => {
  no_parse_args => 1,
  code => sub {
    my ($self, $args, %info) = @_;
    my $sx = [user=>{}, desc_gen(dg_escape($args), self => $self)];
    $self->sact($info{opt_pre} ? ['html:pre'=>{}, $sx] : $sx);
    return;
  },
}, 
#---------------------------------------------------------------------------------------------------
};

Define PrefDefaults => {
  speech_filter => 0,
};

Define Methods => {

speak => sub {
  my ($self, %params) = @_;
  
  my $text = $params{text} || $params{cargs}[1];
  (undef, undef, my %cmd_info) = @{$params{cargs} || []};

  $self->can_speak or die "CFAIL:You don't seem to have anything to speak with.";
  
  if ($cmd_info{connection} and $cmd_info{connection}->pref('speech_filter') and !$cmd_info{opt_raw}) {
    # disallow weird punctuation
    $text =~ tr/-A-Za-z0-9!%$():;'",.? //cd;
    $text =~ s/([^\w\s'"])[^\w\s'"]+/$1/g;

    # clean up capitalization, add period, expand abbreviations...
    $text =~ s/([^?!:;.])\s*$/$1./;
    $text =~ s/\bi\b/I/g;
    $text =~ s/\bu\b/you/gi;
    $text =~ s/\br\b/are/gi;
    
    $text = ucfirst $text;
  }
  
  $params{label} = 'asks' if $text =~ /\?$/ and $params{label} eq 'says';
  $params{label} = 'exclaims' if $text =~ /\!$/ and $params{label} eq 'says';
  
  if ($text =~ /[a-z]|./i) {
    my $dg = desc_gen("<self.aud?<self> <v:".$params{label}.">, \"" . dg_escape($text) . '">', self => $self);
    $self->sact([action=>{}, [ucfirst=>{'xml:space'=>'preserve'}, $dg]]);
  } elsif (length $text) {
    $self->nact('<self.aud?<self> <v:mumbles>.>');
  } else {
    die "CFAIL:" . ucfirst(Lingua::EN::Inflect::PL_V($params{label})) . " what?";
  }
  return;
},  

};

=for later=

  # reenable this code when drunkenness is back
  
  my $is_drunk = 0;
  if (0 and $is_drunk = $self->drunk > 5) {local $_ = $text; for my $i (1..$self->drunk - 5) {
    &{[
      sub {s/s/th/i},
      sub {s/le/la/i},
      sub {s/\B([a-df-ln-z])\1\B/$1$1-$1$1/i},
      sub {s/je/she/i},
      sub {s/go/guh/i},
      sub {s/ou/aw/i},
      sub {s/o/er/i},
      sub {s/u/ho/i},
      sub {s/e/ay/i},
      sub {s/e/ra/i},
      sub {s/\B[a-z]\B//i},
      sub {s/\s([\w])\B/ $1-$1-$1/i},
      sub {s/(\w{8})/"$1 *hic*"/ei},
      sub {s/ic/ic-hic/i},
    ]->[rand 14]};
  }; $text = $_;}

  my $drt = $is_drunk > 5 ? ' drunkenly' : '';
=cut
