Require 'commands', 'containment';

Define Hooks => {
'con_attached' => sub {
  my ($con, $obj, $extra) = @_;
  return if $extra and $extra eq 'web';
  $obj->nact("<self.is!<self.vis?[ <self> has attached. ]>>");
},
'con_detached' => sub {
  my ($con, $obj, $extra) = @_;
  return if $con->isa('MConnection::Capturing'); # FIXME: in new model, this ought to be based on interface type. see todo.
  if ($extra) {
    $obj->nact("<self.is!<self.vis?[ <self> has detached. ]>>")
      if $extra eq 'detach command';
    $obj->nact("<self.is!<self.vis?[ <self> has lost <self.ppron> connection. ]>>")
      if $extra eq 'remote disconnect';
  }
  if ($obj->getAttr('name') =~ /^guest \[\d+\]$/) {
    $con->send("Guest body destroyed.");
    mudlog "Destroying guest body #".$obj->id.".";
    $obj->destroy;
  }
},
'new_connection' => sub {
  my ($con) = @_;
  $con->setstate('login');
},
prompt_info => sub {
  $_[0] ? $_[0]->getAttr('name') : ();
},
};

Define PrefDefaults => {
  prompts => 1,
};

my $create_body = sub {
  my ($con, $user) = @_;

  my $isguest = !$user;
  my $name = $isguest ? 'guest ['.$con->id.']' : $user->name;
  my $obj = MObject->new(
    name => $name,
    ($isguest ? () : (article => '')),
    'prototype' => 'PspcHuman',
    owner => '*',
  );
  $user->set(object => $obj) if $user;

  $con->id_log("created body named '$name' #".$obj->id);
  $con->send([report=>{}, [line=>{}, 'Body created.']]);
  
  $obj->move_into(ObjectByName('Rstart'), action => 'bodyCreation');
  return $obj;    
};

Define ConnectionMethods => {
  input_mode_push => sub {
    my ($self, $name, $sub) = @_;
    $self->data('nested_input_stack', [@{$self->data('nested_input_stack')}, [$sub, $name]]);
    my $adv = $self->pref('advice');
    if ($adv >= 1 or not $self->pref('prompts')) {
      my $msg = qq{Entered input mode "$name".};
      if ($adv == 2) {
        $msg .= ' Type ^ to exit, or ^cmd to input to previous mode.';
      } elsif ($adv == 3) {
        $msg = "You have entered the 'nested input mode' named '$name'. An input mode might simply provide some special commands, or may completely change how input is interpreted. To exit from this mode, type ^ (caret) or anything the input mode does not understand. To override this input mode and enter text for the previous input mode, place a ^ before your text.";
      }
      $self->send([report=>{}, $msg]);
    }
  }
};

my $exited_nest = sub {
  my ($self, $nest) = @_;
  if ($self->pref('advice') >= 1 or not $self->pref('prompts')) {
    $self->send([report=>{}, qq{Left input mode "$nest->[1]".}]);
  }
};

Define Commands => {
  attach => {
    no_object => 1,
    code => sub {
      my ($con, $args, %info) = @_;
      
      my $obj;
      $obj = eval {$con->user->get('object')} or $obj = $create_body->($con, $con->user);
      
      $obj->ref_exists or do {
        $con->user->set('object', undef);
        die "CFAIL:Sorry, but your character doesn't seem to exist any more. Type 'attach' again to create a new one.";
      };
      
      $con->attach($obj, 'attach command');
      $con->id_log("attached to #".$obj->id.".");
      $con->cmd_execute($obj, 'look', '');
      return;
    },
  },
  detach => {
    code => sub {
      my ($self, $args, %info) = @_;
      $info{connection}->detach($self, 'detach command');
      return unless $self->ref_exists;
      $info{connection}->send([report=>{}, [line=>{}, "Detached from ",[obj=>{}, $self->nphr],". To disconnect, type 'disconnect'."]]);
      return;
    },
    help => 'Disconnects from your character.',
  },
  logout => {
    no_object => 1,
    code => sub {
      my ($self, $args, %info) = @_;
      $self->user(undef);
      $self->setstate('login');
      return;
    },
    help => 'Returns you to the login prompt.',
  },
  disconnect => {
    no_object => 1,
    aliases => [qw(quit)],
    code => sub {
      my ($con, $args, %info) = @_;
      $con->send([report=>{},"Disconnecting."]);
      $con->disconnect('normal');
      return;
    },
  },
  password => {
    aliases => [qw(passwd)],
    no_object => 1,
    code => sub {
      my ($con, $args, %info) = @_;
      $con->setstate('newpass_old');
      return;
    },
  },
};

Define States => {
'login' => { # name request
  entry => sub {
    my ($self, $reason) = @_;
    
    return if $reason and $reason eq 'badname';
    $self->send_str(<<"EOT") if $self->terminal->isa('MTerminal::ANSI');
 _________________________________ Welcome To _________________________________
 
                                   \c[[31mMMMM\c[[0m       \c[[31mMMMM\c[[0m \c[[35mUUUU\c[[0m      \c[[35mUUUU\c[[0m \c[[34mDDDDDDDDDD\c[[0m
                                   \c[[31mMMMMM\c[[0m     \c[[31mMMMMM\c[[0m \c[[35mUUUU\c[[0m      \c[[35mUUUU\c[[0m \c[[34mDDDDDDDDDDD\c[[0m
 \c[[32mmmmmmmmmmmmmmmmmm\c[[0m   \c[[32mpppppppppp\c[[0m    \c[[31mMMMMMM\c[[0m   \c[[31mMMMMMM\c[[0m \c[[35mUUUU\c[[0m      \c[[35mUUUU\c[[0m \c[[34mDDDD\c[[0m    \c[[34mDDDD\c[[0m
 \c[[32;42mmmmmmmmmmmmmmmmmmm\c[[0m  \c[[32;42mppppppppppp\c[[0m   \c[[31;41mMMM\c[[0m \c[[31;41mMMM\c[[0m \c[[31;41mMMM\c[[0m \c[[31;41mMMM\c[[0m \c[[35;45mUUUU\c[[0m      \c[[35;45mUUUU\c[[0m \c[[34;44mDDDD\c[[0m     \c[[34;44mDDDD\c[[0m
 \c[[32;42mmmmm\c[[0m   \c[[32;42mmmmm\c[[0m   \c[[32;42mmmmm\c[[0m  \c[[32;42mpppp\c[[0m    \c[[32;42mpppp\c[[0m  \c[[31;41mMMM\c[[0m  \c[[31;41mMMMMM\c[[0m  \c[[31;41mMMM\c[[0m \c[[35;45mUUUU\c[[0m      \c[[35;45mUUUU\c[[0m \c[[34;44mDDDD\c[[0m     \c[[34;44mDDDD\c[[0m
 \c[[32;42mmmmm\c[[0m   \c[[32;42mmmmm\c[[0m   \c[[32;42mmmmm\c[[0m  \c[[32;42mpppp\c[[0m    \c[[32;42mpppp\c[[0m  \c[[31;41mMMM\c[[0m   \c[[31;41mMMM\c[[0m   \c[[31;41mMMM\c[[0m \c[[35;45mUUUU\c[[0m      \c[[35;45mUUUU\c[[0m \c[[34;44mDDDD\c[[0m     \c[[34;44mDDDD\c[[0m
 \c[[32mmmmm\c[[0m   \c[[32mmmmm\c[[0m   \c[[32mmmmm\c[[0m  \c[[32mpppp\c[[0m    \c[[32mpppp\c[[0m  \c[[31mMMM\c[[0m    \c[[31mM\c[[0m    \c[[31mMMM\c[[0m  \c[[35mUUUU\c[[0m    \c[[35mUUUU\c[[0m  \c[[34mDDDD\c[[0m    \c[[34mDDDD\c[[0m
 \c[[32mmmmm\c[[0m   \c[[32mmmmm\c[[0m   \c[[32mmmmm\c[[0m  \c[[32mppppppppppp\c[[0m   \c[[31mMMM\c[[0m         \c[[31mMMM\c[[0m   \c[[35mUUUUUUUUUU\c[[0m   \c[[34mDDDDDDDDDDD\c[[0m
 \c[[32mmmmm\c[[0m   \c[[32mmmmm\c[[0m   \c[[32mmmmm\c[[0m  \c[[32mpppppppppp\c[[0m    \c[[31mMMM\c[[0m         \c[[31mMMM\c[[0m     \c[[35mUUUUUU\c[[0m     \c[[34mDDDDDDDDDD\c[[0m
                     \c[[32mpppp\c[[0m
                     \c[[32mpppp\c[[0m                               Created by Kevin Reid
                     \c[[32mpppp\c[[0m                                   <kpreid\@kagi.com>
 ______________________________________________________________________________
EOT
  },
  prompt => "Please enter existing account name, new account name, or 'guest': ",
  input => sub {
    my ($self, $input) = @_;
    $input =~ s/^\s+//;
    $input =~ s/\s+$//;
    $input or return;
    
    my ($username, $password);
    
    if ($input =~ /^quit$/i) {
      $self->disconnect('normal');
      return;
    
    } elsif ($input =~ /^connect (.*)$/i) {
      ($username, $password) = split /\s+/, $1;
      
    } else {
      $username = $input;
    
    }
    
    $username = lc $username;
    $password ||= '';
    
    if ($username eq 'guest') {
      # guests just get logged in without a user
      $self->setstate('command', 'login');  
    } elsif (!MUser->exists($username)) {
      # if there's no such user, ask about creation
      $self->data('login_username', $username);
      $self->setstate('confirm_name');
    } else {
      # there is a user
      my $user = MUser->get($username);
      if (!$user->has_password) {
        # if no password, the user must set it immediately
        $self->user($username);
        $self->send([error=>{}, 'This account has no password!']);
        $self->setstate('newpass_new');
        
      } elsif ($user->authenticate($password)) {
        # successful login
        $self->user($username);
        $self->setstate('command', 'login');
        
      } else {
        # account has password, but it wasn't given
        if (length $password) {
          # user entered wrong password
          $self->send([error=>{}, 'Incorrect password.']);
          $self->disconnect("bad login attempt");
        } else {
          # user entered no password
          $self->data('login_username', $username);
          $self->setstate('pass');
        }
      }
    }
  },
  timeout => 3*60*60, # three hours
},
'pass' => { # enter password for existing account
  prompt => 'Password: ',
  no_echo => 1,
  input => sub {
    my ($self, $input) = @_;
    my $user = MUser->get($self->data('login_username'));
    unless ($user->authenticate($input)) {
      $self->send([error=>{}, 'Incorrect password.']);
      $self->id_log("bad login attempt for " . $self->data('login_username'));
      $self->setstate('login');
      return;
    }
    $self->user($user);
    $self->setstate('command', 'login');
  },
  timeout => 1*60,
},
'newpass_old' => { # setting new password, enter old password first
  prompt => 'Enter your old password: ',
  no_echo => 1,
  input => sub {
    my ($self, $input) = @_;
    $input or do {$self->send("Cancelled."); $self->setstate('command'); return};
    unless ($self->user->authenticate($input)) {
      $self->send('Incorrect password.');
      $self->setstate('command');
      return;
    }
    $self->setstate('newpass_new');
  },
  timeout => 3*60,
},
'newpass_new' => { # setting new password, enter new password
  prompt => sub {'Enter '.($_[0]->user->has_password?'new ':'a ')."password for ".$_[0]->user->name.": "},
  no_echo => 1,
  input => sub {
    my ($self, $input) = @_;
    if (not $input) {
      if (not $self->user->has_password) {
        $self->send("You must choose a password."); 
      } else {
        $self->send("Cancelled."); 
        $self->setstate('command'); 
      }
    } else {
      $self->data("new_password", $input);
      $self->setstate('newpass_new2');
    }
  },
  timeout => 3*60,
},
'newpass_new2' => { # setting new password, confirm new password
  prompt => sub {'Enter your '.($_[0]->user->has_password?'new ':'').'password again: '},
  no_echo => 1,
  input => sub {
    my ($self, $input) = @_;
    if ($input eq $self->data("new_password")) {
      my $hadprev = $self->user->has_password;
      $self->user->set_password($input);
      $self->send('Password set.');
      $self->setstate('command', $hadprev ? () : 'login');
    } else {
      $self->send("The two passwords did not match.");
      $self->setstate('newpass_new');
    }
    $self->data("new_password", undef);
  },
  timeout => 1*60,
},
'confirm_name' => { # no such account, create new one?
  prompt => sub {'There is no account named "' . $_[0]->data('login_username') . '". Create a new account? [y/N]? '},
  input => sub {
    my ($self, $input) = @_;
    if ($input !~ /^y/i) {
      $self->setstate('login', 'badname');
      return;
    }
    $self->send("Creating new account.");
    $self->user(MUser->new($self->data('login_username')));
    $self->setstate('newpass_new');
  },
  timeout => 3*60,
},
'command' => { # pass input to command interpreter
  entry => sub {
    my ($self, $reason) = @_;
    
    if ($reason and $reason eq 'login') {
      $self->id_log("logged in (entered command state).");
      $self->cmd_execute(undef, 'whoami', '');
    }
    $self->send([report=>{}, [title=>{}, "Useful commands"],
      ['html:ul',{},
        ['html:li',{}, "disconnect: Disconnect from $::Config{'name'}"],
        ['html:li',{}, 'attach: Begin controlling your character'],
        ['html:li',{}, "help: Get help on using $::Config{'name'}"],
        ['html:li',{}, "commands: List the commands you can use"],
      ],
    ]) if $self->pref('advice') >= 2 and $reason and ($reason eq 'login' or $reason eq 'menu');

    $self->data('nested_input_stack', []);
  },
  prompt => sub {
    return '' unless $_[0]->pref('prompts');
    my $obj = $_[0]->object;
    $obj = undef unless $obj && $obj->ref_exists;
    return join(' ',
      call_ordered_hooks('prompt_info', $obj, $_[0]),
      map("($_->[1])", @{$_[0]->data('nested_input_stack')}),
    ) . "> ";
  },
  input => sub {
    my ($self, $input) = @_;
    
    my @nstack = @{$_[0]->data('nested_input_stack')};
    NEST: for (my $i = $#nstack; $i >= 0; $i--) {
      my $nest = $nstack[$i];
      
      #mudlog "nest processing i$i $nest->[1] >>$input<<";
      if ($input =~ s/^\^//) {
        if (not length $input) {
          $exited_nest->($self, $nest);
          splice @nstack, $i, 1;
          $_[0]->data('nested_input_stack', \@nstack);
          return;
        } else {
          next NEST;
        }
      }
      
      my $result = $nest->[0]->($self, $input);
      if (!$result or $result eq 'done') {
        # if done or unrecognized, pop the state
        $exited_nest->($self, $nest);
        splice @nstack, $i, 1;
        $_[0]->data('nested_input_stack', \@nstack);
        return if $result eq 'done';
      } elsif ($result eq 'continue') {
        return;
      } else {
        die "Bad return value from nested input closure '$nest->[1]': $result";
      }
    }
    if ($input =~ /^!/) {
      $input = $self->data('last_command') || '';
    }
    $self->cmd_do($self->object, $self->data(last_command => $input));
  },
},
};

Require 'core';
Define Actions => {
  'motion-bodyCreation' => '<self.vis?Suddenly, dust gathers out of the air, forming a human shape which grows solid.>',
},
