Require 'core';

use strict;

Define Fields => {
  voluntary_carry => {default => 0},
  display_desc => {default => "<holder.vis?<self.vis?<holder> <v:displays> <holder.ppron> <self.name>.>>"},
  cnt_lock_shape => {},
  cnt_locked => {default => 0},
  cnt_auto_lock => {default => 0},
  cnt_transparent => {default => 0}, # FIXME: implement this: allows chars inside container to see exterior area
  key_shape => {},
  is_tag => {},
  sdesc => {},
  no_drop => {},
  complement => {},
};

Define Commands => {
look => {
  aliases => [qw(l examine read)],
  basic => 1, 
  code => sub {
    my ($self, $args, %info) = @_;
    
    return unless $self->uses_output;
    MModules->loaded('body_pos') and $self->bp_assert('look', 'look');
    
    my $lookin =
       $args =~ s/^(at?|in?)\s+//
       && $1 =~ /i/i;

    my ($obj, @obj);

    if ($args) {
      $obj = $self->object_find($args);
    } else {
      $obj = $self->container or return [report=>{}, [error=>{}, "You see nothing at all."]];
    
      push @obj, $obj;
      push @obj, $obj = $obj->container while $obj->glance_contents and $obj->container;
      #$self->send(@obj);
    }

    my $outward = $self->is_inside($obj) && !($obj->glance_contents && $obj->cnt_type eq 'open');

    $self->nact('<self!<self> looks at <obj>.>', obj => $obj)
      unless $obj == $self or $obj->is_inside($self) or $outward;
      
    my $rep = [report=>{}];
 
    if (!$lookin) {
      my @extra;
      my $user;
      if ($info{connection} and $user = $info{connection}->user and $user->privileged('watcher')) {
        my $proto = $obj->prototype;
        push @extra, (ref $proto ? $proto->id : $proto) . ": " if defined $proto;
        push @extra, "#" . $obj->id;
        for ($obj->getNames) {
          push @extra, " \$$_";
        }
      }
      push @$rep,
        [title=>{},
          (@extra ? ("[", @extra, "] ") : ()),
          [obj=>{part=>'nphr_details'}, $obj],
        ];

  
      my @sdescs = map {($info{connection}->user->privileged('watcher') ? '^' : ()), [ucfirst=>{}, desc_gen($_->sdesc, 'self' => $_, in => $obj)]} 
                   grep $self->can_see($_) && $_->sdesc,
                   @{$obj->contents};
      my @desc = (desc_gen(($outward ? $obj->idesc : $obj->ldesc), 'self' => $obj), ' ', @sdescs);

      push @$rep, [detail=>{},
        ['html:p',{}, @desc],
        map(['html:p'=>{}, $_],
          call_hooks('look_extra_info', $obj, $self, outward => $outward)
        ),
      ];
    }

    if ($outward or $obj->cnt_interior or $obj->cnt_type eq 'open') {
      if ($obj->cnt_closed and !$outward) {
        push @$rep, [line=>{}, [ucfirst=>{}, $obj, " is closed."]];
      } else {
        push @$rep, [title=>{},
          $obj == $self ? 'You are carrying'
            : (ucfirst($obj->enter_prep),' ',[obj=>{part=>'opron'}, $obj])
        ] if !$outward;
        
        my $desc_meth = $outward ? 'desc_in_room' : 'nphr_details';
        my $prefix = $outward ? '  ' : '  ';

        if (my @cont =
              grep $self->can_see($_) && (!$outward or $_->id ne $self->id) && !$_->sdesc,
              @{$obj->contents}
        ) {
          push @$rep, ['html:ul',{'html:class'=>'structure'},
            map ['html:li',{}, $_->$desc_meth($self)], @cont
          ];
        } else {
          push @$rep, ['html:p'=>{}, 'Nothing.'] unless $outward;
        }
      }       
    }

    return $rep;
  },
  help => <<'EOHELP',
look
look &:meta;<object>&:n;
look around

'look' tells you about your surroundings. 'look &:meta;<object>&:n;' tells you about that object. 'look around' tells you about nearby locations.
EOHELP
},
inventory => {
  aliases => [qw(i)],
  code => sub {my ($s,$a,%i) = @_; $i{connection}->cmd_execute($s, 'look', 'in self'); return},
  help => 'Exactly equivalent to "look in self".'
},
get     => {code => 'GenericVerb', aliases => [qw(g t take remove acquire)], findopt => {no_self_contents => 1}, junk_prefixes => ['off']},
drop    => {code => 'GenericVerb', aliases => [qw(put place set)],findopt => {no_outside => 1}, junk_prefixes => ['down']},
give    => {code => 'GenericVerb', aliases => [qw(offer)],findopt => {no_outside => 1, symbols => 1}},
enter   => {code => 'GenericVerb', aliases => [qw(climb)]},
display => {code => 'GenericVerb', aliases => [qw(show)]},
rub     => {code => 'GenericVerb'},
'open'  => {code => 'GenericVerb'},
'close' => {code => 'GenericVerb', aliases => [qw(shut)]},
lock    => {code => 'GenericVerb'},
unlock  => {code => 'GenericVerb'},
eat     => {code => 'GenericVerb', aliases => [qw(taste gobble)]},
drink   => {code => 'GenericVerb', aliases => [qw(sip quaff)]},
equip   => {code => 'GenericVerb', aliases => [qw(wear wield hold grab)]},
leave => {
  aliases => [qw(out exit)],
  code => sub {
    my ($self, $args) = @_;
    
    my $hasbp = MModules->loaded('body_pos');
    $hasbp and $self->bp_assert('reach_object') and $self->bp_assert('move');

    my $pcon;
    $pcon = $self->container or return [error=>{}, "You aren't inside anything! How can you leave?"];

    $pcon->cnt_closed and return [error=>{}, $self->can_see($pcon) ? ($pcon, " is closed.") : "You can't find a way out."];

    my $obj = $pcon->container or return [error=>{}, "There's nothing to leave to."];
    $obj->can_contain($self) or return [error=>{}, "There's no room for you to get out of ", $pcon, "."];

    $self->nact('<self> <v:leaves> <pcon>.', self => $self, pcon => $pcon);
    $self->move_into($obj);
    $self->nact('<self!<self> gets out of <pcon>.>', self => $self, pcon => $pcon) if !$pcon->glance_contents;
  },
},
};

Define Verbs => {
get => sub {
  my ($self, $caller, %objects) = @_;
  
  MModules->loaded('body_pos') and $caller->bp_assert('reach_object');
  my $from;
  if ($from = $self->container) {
    $from->voluntary_carry and die "CFAIL:Try asking nicely.";
    $from->cnt_closed and !$caller->is_inside($from) and return [error=>{}, $from, " is closed."];
  }
  $caller->can_contain($self) or return [error=>{}, [obj=>{part=>'poss'}, $self], " too big for you to carry."];
  $caller == $self and die "CFAIL:You can't pick yourself up (by your bootstraps or not)!";
  $caller->is_inside($self) and return [error=>{}, "You can't get ",$self," because you're inside ",[obj=>{part=>'opeon'},$self],"!"];
  
  $self->move_into($caller, actor => $caller, action => 'get');
},
drop => sub {
  my ($self, $caller, %objects) = @_;
  MModules->loaded('body_pos') and $caller->bp_assert('reach_inventory');

  my $into = $objects{in} || $objects{on} || $objects{among} || $caller->container;
  
  $caller == $self and die "CFAIL:You can't do that!";
  $into->cnt_closed and !$caller->is_inside($into) and return [error=>{}, $into, " is closed."];
  if ($self->is_tag) {
    $into->voluntary_carry or die "CFAIL:" . $self->no_drop;
  } else {
    $into->voluntary_carry and die "CFAIL:Use 'give' instead.";
    $self->no_drop and die "CFAIL:" . $self->no_drop;
  }
  $into->can_contain($self) 
    or return [error=>{}, "There's no room ".$into->enter_prep." ",$into," for ",$caller," to drop ",$self,"."];
  $into == $self and return [error=>{}, "You can't put ",$into," into ",[obj=>{part=>'opron'},$into],"self!"];
  $into->is_inside($self) and return [error=>{}, $into, " is inside ", $self, "!"];

  $self->move_into($into, actor => $caller, action => 'drop');
},
'open' => sub {
  my ($self, $caller, %objects) = @_;
  MModules->loaded('body_pos') and $caller->bp_assert('reach_object', 'open things');

  $self->cnt_locked and return [error=>{}, $self, " is locked."];
  !$self->cnt_closed and return [error=>{}, $self, " is already open."];
  
  $self->nact('<a> <v:opens> <self>.', a => $caller);
  $self->cnt_closed(0);
},
'close' => sub {
  my ($self, $caller, %objects) = @_;
  MModules->loaded('body_pos') and $caller->bp_assert('reach_object', 'close things');

  $self->cnt_closed and return [error=>{}, $self, " is already closed."];
  
  $self->nact('<a> <v:closes> <self>.', a => $caller);
  $self->cnt_closed(1);
  $self->cnt_locked(1) if $self->cnt_auto_lock;
},
'lock' => sub {
  my ($self, $caller, %objects) = @_;
  MModules->loaded('body_pos') and $caller->bp_assert('reach_object', 'lock things');

  $self->cnt_lock_shape or return [error=>{}, $self, " isn't lockable."];
  # FIXME: should enter input mode here
  my $using = $objects{using} || $objects{with} or return [error=>{}, "Lock ", $self, " with what?"];

  $self->cnt_locked and return [error=>{}, $self, " is already locked."];
  !$self->cnt_closed and return [error=>{}, $self, " is open."];

  $using->key_shape eq $self->cnt_lock_shape or return [error=>{}, $using, " doesn't fit."];
  
  $self->nact('<a> <v:locks> <self>.', a => $caller);
  $self->cnt_locked(1);
},
'unlock' => sub {
  my ($self, $caller, %objects) = @_;
  MModules->loaded('body_pos') and $caller->bp_assert('reach_object', 'unlock things');

  $self->cnt_lock_shape or return [error=>{}, $self, " isn't lockable."];
  my $using = $objects{using} || $objects{with} or return [error=>{}, "Unlock ", $self, " with what?"];

  !$self->cnt_locked and return [error=>{}, $self, " isn't locked."];
  
  $using->key_shape eq $self->cnt_lock_shape or return [error=>{}, $using, " doesn't fit."];
  
  $self->nact('<a> <v:unlocks> <self>.', a => $caller);
  $self->cnt_locked(0);
},
enter => sub {
  my ($obj, $self, %objects) = @_;
  
  MModules->loaded('body_pos') and $self->bp_assert('move');
  if (my $con = $obj->container) {
    $con->cnt_closed and !$self->is_inside($con) and return [error=>{}, $con, " is closed."];
  }
  $obj->can_contain($self) or return [error=>{}, "There's no room for ",$self," ".$obj->enter_prep." ",$obj,"."];
  $self == $obj and return [error=>{}, "That would be interesting..."];
  $self->is_inside($obj) and  return [error=>{}, $self, " is already inside ",$obj,"!"];
  
  $self->entered_from($self->container);
  
  $self->nact('<self> <v:enters> <obj>.', obj => $obj);
  $self->move_into($obj);
},
give => sub {
  my ($obj, $self, %objects) = @_;
  
  MModules->loaded('body_pos') and $self->bp_assert('reach_object');
  
  my @obj = $obj;
  my $offname = join ', ', map "<#$_>", map $_->id, @obj;

  my $to = ($objects{'to'} or do {
    return [error=>{}, desc_gen("Give $offname to who?")];
  });

  $to->voluntary_carry or die "CFAIL:Use 'put' instead.";
      
  $self->doing and return [error=>{}, "You're busy ", desc_gen($self->doing), "."];

  $obj->no_drop and die "CFAIL:" . $obj->no_drop;

  $to->can_see($self) or do {
    $self->nact("<self.vis?<self> <v:holds> out $offname to <to><to.vis?, but <to.opron> doesn't notice>.>", to => $to);
    return;
  };

  $self->nact("<self> <v:offers> $offname to <to>.", to => $to);
  $self->doing("offering $offname to <#".$to->id.">");
  $self->do_stop(MEvent::Message->new(
    target => $self,
    method => 'give_stop',
    arguments => [$to, $offname],
  ));
  my $offs = $to->getAttr('offers');
  push @$offs, {
    name => $offname,
    'accept' => MEvent::Message->new(
      target => $to,
      method => 'give_accept',
      arguments => [$self, @obj],
    ),
    deny => MEvent::Message->new(
      target => $to,
      method => 'give_deny',
      arguments => [$self, $offname],
    ),
    failed => MEvent::Message->new(
      target => $to,
      method => 'give_failed',
      arguments => [$self],
    ),
  };
  $to->setAttr('offers', $offs);
},
};

Define Methods => {

GenericVerb => sub {
  my ($self, $cmd, $args) = @_;
      
  my @pieces = split /\s*\b(at|by|in|on|to|under|using|with|among)\b\s*/oi, $args;
  my $direct_obj = shift @pieces;
  my %objs = map {lc} @pieces;
  %objs = map {$_, $self->object_find($objs{$_}, verb => $cmd)} keys %objs;
  
  foreach my $obj ($self->object_find(
    $direct_obj,
    verb => $cmd,
    %{MDefList->path('/Commands')->get($cmd)->{findopt} || {}}  
  )) {
    $self->do_verb($cmd, $obj, %objs);
  }
},

do_verb => sub {
  my ($self, $verb, $obj, %objects) = @_;
  
  if (my $code = MDefList->path('/Verbs')->get($verb)) {
    $code->($obj, $self, %objects);
  } else {
    $self->send([error=>{}, [ucfirst=>{}, $self, " can't $verb ", $obj, "."]]);
  }
},

do_nouns => sub {
  my ($self, @objs) = @_;
  $self->send("do_nouns called with", map +(', ', $_), @objs);
},

give_stop => sub {
  my ($self, $to, $offname) = @_;
  @{$to->offers} = grep {$_->{name} ne $offname} @{$to->offers};
},

give_accept => sub {
  my ($self, $from, @obj) = @_;

  $from->ref_exists or die "CFAIL:".ucfirst $from->nphr." doesn't exist anymore.";
  foreach my $obj (@obj) {
    if (!$self->can_contain($obj)) {
      $self->send([ucfirst=>{}, desc_gen("<o.poss> too big for <to> to carry.", to => $self, obj => $obj)]);
      $from->send([ucfirst=>{}, desc_gen("<to> can't hold <obj>.",              to => $self, obj => $obj)]);
      next;
    }
    $self->nact("<self> <v:takes> <obj> from <from>.", obj => $obj, from => $from);
    $obj->move_into($self);
  }
  $from->resetAttr('doing');
  $from->resetAttr('do_stop');
},

give_deny => sub {
  my ($self, $from, $offname) = @_;

  $from->ref_exists or die "CFAIL:".ucfirst $from->nphr." doesn't exist anymore.";
  $self->nact("<self> reject<self!s> $offname.");
  $from->resetAttr('doing');
  $from->resetAttr('do_stop');
},

give_failed => sub {
  my ($self, $from) = @_;

  $from->ref_exists or return;
  $from->resetAttr('doing');
  $from->resetAttr('do_stop');
},

nphr_details => sub {
  my ($self) = @_;
  return [obj=>{part=>'nphr_details'}, $self];
},

desc_in_room => sub {
  my ($self, $viewer) = @_;

  # things that need to be displayed: nphr, contents if glance_, body_pos, doing

  my $cont = $self->contents;
  my $inside;
  my @contsx;
  my @vis_cont = grep $viewer->can_see($_), @$cont;
  
  if ($self->glance_contents and !$self->cnt_closed and @vis_cont == 1) {
    $inside = $self;
    $self = $vis_cont[0];
    $cont = $self->contents;
    @vis_cont = grep $viewer->can_see($_), @$cont;
  }
  
  my $plural = $self->gender eq 'plural';

  if ($self->glance_contents and !$self->cnt_closed  and @vis_cont > 1) {
    @contsx = map +([obj=>{part=>'nphr_details'}, $_], ', '), @vis_cont;
    pop @contsx;
    $contsx[-2] = ' and ' if @contsx > 1;
  }

  # note: complements must be wrapped in anon arrays, including
  # object_description_complements hook results!

  my @complements = sort {@$a <=> @$b} (
    (@contsx ? ["with ", @contsx, " ", $self->enter_prep, ' ', [obj=>{part=>'opron'},$self]] : ()),
    call_hooks('object_description_complements', $self),
  );
  
  my $first_complement = shift @complements;

  return [ucfirst=>{},
    [obj=>{part=>'nphr_details', no_substitution => 1}, $self],
    ' ', 
    ($plural           ? 'are' : [verb=>{s=>'is',subj=>$self}]),
    ($first_complement ? (' ', @$first_complement) : ()),
    ($inside           ? (' ' . $inside->enter_prep . ' ', [obj=>{part=>'nphr_details', no_substitution => 1}, $inside]) : " here"),
    (map +(', ', @$_), @complements),
    '.'
  ];
},

};

Define Hooks => {
  object_description_complements => sub {
    my ($self) = @_;

    (
      ($self->getAttr('cnt_closeable') ? [$self->getAttr('cnt_closed') ? 'closed' : 'open'] : ()),
      ($self->getAttr('doing') ? [desc_gen($self->doing)] : ()),
      ($self->getAttr('complement') ? [$self->getAttr('complement')] : ()),
    );
  },
};

Define Actions => {
  #'motion'      => '[motion: <obj> into <to> from <from>]',
  'motion-get'  => '<actor> <from.is(<actor.viscontext>)?<v:actor:picks> <self?you up:up <self>>:<v:actor:takes> <self> from <from>>.',
  'motion-drop' =>   '<actor> <to.is(<actor.viscontext>)?<v:actor:drops> <self>:<v:actor:puts> <self> <to.prep> <to>>.',
};