Require 'commands', 'containment', 'connections';

use MConnection::Capturing;
use MEvent::Subroutine;
use MIOManager;
use Fcntl;

BEGIN {
  eval "use HTTP::Daemon; use HTTP::Status qw(!/^is_/); use URI::Escape (); ";
  if ($@) {
    mudlog "Web: Could not load HTTP:: modules.";
    die "module load failed";
  }
}

my $CRLF = "\cM\cJ";

my $handler = sub {
  my ($c) = @_;
  
  # FIXME: get_request blocks; the delay before calling $handler SHOULD prevent
  # any problem, but it still could.
  $c->timeout(0);
  my $req = $c->get_request() or mudlog("Web: Bad HTTP request!"), return;
  
  my $url = $req->url;
  my $path = $url->path;
  mudlog "Web: HTTP " . $req->method . " $url";
  $path =~ tr#/#~#;
  
  eval {
    my $wi = MDefList->root->get('WebItems')->get($path)
      or $c->send_error(RC_NOT_FOUND), return;

    my ($user, @error);
    AUTHENTICATE: {
      $wi->{authenticate} or last AUTHENTICATE;

      my ($username, $password);
      
      $req->authorization or @error = ("Account Login Required",
        "Authorization is required for accessing ".$url->path.".\cJ"), last AUTHENTICATE;
      
      use MIME::Base64;
      my ($scheme, $b64) = split /\s+/, $req->authorization;
      ($username, $password) = split /:/, decode_base64($b64);

      MUser->exists($username)       or @error = '*bad*', last AUTHENTICATE;
      $user = MUser->get($username);
      $user->authenticate($password) or @error = '*bad*', last AUTHENTICATE;
    }
    if (@error) {
      @error = ("Incorrect Login", "Either the user '$user' does not exist,\cJor you entered the password incorrectly.\cJ")
        if $error[0] eq "*bad*";
      $c->send_response(new HTTP::Response RC_UNAUTHORIZED, $error[0],
        HTTP::Headers->new(Content_Type => 'text/plain', WWW_Authenticate => qq{Basic realm="$::Config{name}"}),
        $error[1],
      );
      return;
    }
      
    if ($wi->{type} eq 'data' or $wi->{type} eq 'file') {
      $c->send_error(RC_METHOD_NOT_ALLOWED, "Only GET requests supported"), return 
        unless $req->method eq 'GET'
        or $req->method eq 'GET_CONDITIONAL'; # please explain this MSIE weirdness
      my $data;
      if ($wi->{type} eq 'file') {
        my $fpath = $wi->{path};
        my $f = IO::File->new(rfile($::Config{web_path} . '/' . $fpath), '<') or do {
          mudlog "ERROR: Web: Could not open file '$fpath' for response: $!";
          $c->send_response(new HTTP::Response
            RC_INTERNAL_SERVER_ERROR, "Could not open file",
            HTTP::Headers->new(Content_Type => 'text/plain'),
            'Could not open file: $!',
          );
          return;
        };
        local $/;
        $data = <$f>;
        
      } else {
        $data = $wi->{data};
      }
      $data =~ s/\[EVAL\[\{(.*?)\}\]\]/$1/gee;
      $c->send_response(new HTTP::Response
        RC_OK, "OK",
        HTTP::Headers->new(Content_Type => ($wi->{Content_Type} || 'text/plain')),
        $data,
      );
    } elsif ($wi->{type} eq 'code') {
      $wi->{code}->($req, $c, $url, $user);
    } else {
      $c->send_error(RC_INTERNAL_SERVER_ERROR);
      mudlog "ERROR: Web: invalid type for web item '$path': '$wi->{type}'\n$@";
    }
  };
  if ($@) {
    $c->send_error(RC_INTERNAL_SERVER_ERROR);
    mudlog "ERROR: Web: exception in handling web request:\n$@";
  }
}; # end of accepter sub

my $accepter = sub {
  my $c = $::ModWebSocket->accept or return;
  mudlog "Web: Accepting HTTP request";
  MEvent::Subroutine->new(name => 'Web Server Handle',
                          'sub' => $handler,
                          arguments => [$c],
                          time => 3, is_real_time => 1
                         )->schedule;
};


{
  my ($addr, $port) = $::Config{'socket'} =~ /(\w+(?:\.\w+)*)?:(\d+)/;
  $addr ||= '';
  mudlog "Web: Opening HTTP listener on $addr:$::Config{web_port}...";
  # FIXME: global variable
  $::ModWebSocket = new HTTP::Daemon (
    LocalAddr => $addr,
    LocalPort => $::Config{web_port},
    Timeout => 0,
    (!IS_MACOS ? (Reuse => 1) : ()),
  ) or die $!;
  fcntl($::ModWebSocket, F_SETFL, fcntl($::ModWebSocket, F_GETFL, 0) | O_NONBLOCK);

  MIOManager->add($::ModWebSocket, 'read', MEvent::Subroutine->new(name => 'Web Server Accept', 'sub' => $accepter));
  
  Unloader sub {
    MIOManager->remove($::ModWebSocket, 'read') if $::ModWebSocket;
    $::ModWebSocket->close if $::ModWebSocket;
    $::ModWebSocket = undef;
  };
}

Define '.' => {
  WebItems => MDefList->new(type => 'HASH'),
};

Define WebItems => {
'~' => {
  type => 'file',
  Content_Type => 'text/html',
  path => 'start.html',
},
'~output-dtd' => {
  type => 'file',
  Content_Type => 'text/plain',
  path => 'output.dtd',
},
'~output-style' => {
  type => 'data',
  Content_Type => 'text/css',
  # FIXME: the stylesheet ought to be auto-generated from internal information (e.g. Elements deflist)
  data => <<'  EOT',
    @namespace html url(http://www.w3.org/1999/xhtml);
    
    connection {
      background-color: black;
      color: white;
      height: auto;
      display: block;
    }
    
    out {
      display: block;
      background-color: black;
      color: white;
      font-family: "Arial Black", Gadget, sans-serif;
      font-size: 12px;
    }
    
    out > * {
      height: auto;
      display: block;
      border-style: solid;
      border-width: .2em .4em;
      border-color: white;
      padding: .5em;
    }
    out:first-child > * { border-top-width: .4em; }
    out:last-child > * { border-bottom-width: .4em; }
    
    report { border-color: blue; }
    action { border-color: purple; }
    error { border-color: red; }
    log { border-color: green; }
    
    line, title { display: block; }
    title { color: #0FF; }
    line { text-indent: 1em; }
    title:after { content: ":"; }  
    
    ucfirst:first-letter { text-transform: uppercase; }
    obj { color: #F3F; }
    :link { color: #66F; text-decoration: underline; }
    :link:active { color: #66F; }

    .mp-interface {
      background-color: gray;
      color: black;
      padding: 2px;
      display: block;
      margin: 0;
      border: none;
    }

    ipre { display: inline; }
    html|pre { display: block; }
    ipre, html|pre {
      white-space: pre;
      font-size: 9px;
      font-family: Monaco, monospace;
    }
    
    html|p {
      display: block;
      text-indent: 2em;
      margin: 0;
      padding: 0;
    }
  EOT
},
'~do' => {
  type => 'code',
  authenticate => 1,
  code => sub {
    my ($request, $hcon, $url, $user) = @_;

    $request->method eq 'POST'
      or $hcon->send_response(new HTTP::Response
        RC_METHOD_NOT_ALLOWED, "Commands must be sent as POST",
	HTTP::Headers->new(Content_Type => 'text/plain'),
	"Commands must be sent as POST",
      );
    
    my $cmd = $request->content;
    $cmd =~ s/^cmd=//;
    $cmd =~ s/\+/ /g;
    $cmd = URI::Escape::uri_unescape($cmd);
 
    my $con = MConnection::Capturing->new;
    $con->terminal('XML');
    
    $con->user($user);
    my $obj = $user->get('object');
    $con->attach($obj, 'web');
    
    $con->cmd_do($obj, $cmd);
    
    my $stuff = $con->disconnect('normal');

    $hcon->send_response(new HTTP::Response
      RC_OK, "OK",
      HTTP::Headers->new(Content_Type => 'text/xml'),
      qq{<?xml version="1.0"?><!--<!DOCTYPE connection SYSTEM "/output-dtd">-->
<?xml-stylesheet type="text/css" href="/output-style"?>
<html:html xmlns:html="http://www.w3.org/1999/xhtml"><html:head>
  <html:title>Did "$cmd"</html:title>
  <script type="text/javascript">alert("Did '$cmd'");</script>
</html:head><html:body>

$stuff

<html:form class="mp-interface" action="/do" method="POST">
Execute command: <html:input type='text' name='cmd'/> <html:input type='submit' value='Do'/>
</html:form>

</html:body></html:html>
},
    );
  },
},
};