my ($field, $value) = split /\s+/, $args;

my %handlers = (
  'width' => sub {
    if ($value) {
      $value = 12 if $value < 12;
      $value = 400 if $value > 400;
      $self->connection->{scr_width} = $value;
      $self->send("Your screen width is now $value.\n");
    } else {
      $self->send("Your screen width is @{[$self->connection->{scr_width}]}.\n");
    }  
  },
  'height' => sub {
    if ($value) {
      $value = 5 if $value < 5;
      $value = 2000 if $value > 2000;
      $self->connection->{scr_height} = $value;
      $self->send("Your screen height is now $value.\n");
    } else {
      $self->send("Your screen height is @{[$self->connection->{scr_height}]}.\n");
    }  
  },
  'color' => sub {
    my $t;
    if ($value) {
      $t = 1 if $value =~ /on|1|true|yes|complete/;
      $t = 0 if $value =~ /off|0|false|no/;
    }
    if (defined $t) {
      $self->connection->{ansi} = $t;
      $self->send("ANSI color is now @{[$t ? 'on' : 'off']}.\n");
    } else {
      $self->send(qq{ANSI color is @{[$self->connection->{ansi} ? 'on' : 'off']}.\n});
    }
  },
);

if (!$field) {
  $self->send("Set what?");
  return;
} else {
  &{$handlers{$field} || sub {$self->send("Sorry, I don't know what that is.")}};
}
