my ($dir, $name) = split /\s+/, $args;

if (!$dir) {
  $self->send("In what direction?");
  return;
}

unless ($name and $name =~ m#/\w+/\w+#) {
  $self->send("That doesn't look like a valid path.");
  return;
}

if ($name !~ m#^@{[$self->myzone]}#) {
  $self->send("You do not have permission to edit that zone.");
  return;
}

if (!$self->container->roomname) {
  $self->send("You aren't in a room!");
  return;
}

if ($self->container->roomname !~ m#^@{[$self->myzone]}#) {
  $self->send("You do not have permission to edit this zone.");
  return;
}

if (!$EXIT_OPP{$dir}) {
  $self->send("I don't know what the opposite of that direction is.");
  return;
}

if ($::Rooms{$name}) {
  $self->send("That room already exists");
  return;
}

$::Rooms{$name} = new MObject (
  'prototype' => ROOM_PROTO,
  exits => {$EXIT_OPP{$dir} => {to => $self->container->roomname, flags => 0}},
  roomname => $name,
  aliases => 'room ' . ($name || ''),
);
$self->container->exits->{$dir} = {to => $name, flags => 0};
$self->act("Okay.",
           $self->name . " points $dir and utters the word '&w;ranwara&n;'");
$self->act(undef, "A bright flash fills the area!");
syslog $self->name . " created room $name";

my ($zone) = $name =~ m#^(.*)/[^/]+$#;
$::DirtyFiles{"room:$zone"} = 1;
($zone) = $self->container->roomname =~ m#^(.*)/[^/]+$#;
$::DirtyFiles{"room:$zone"} = 1;
