if ($args) {
  my ($type, $path, $filepath) = split_file_ref($args);
  $path and $filepath or do {
    $self->send("That isn't a valid file reference, see HELP FILEREF.");
    return;
  };
  if ($path !~ "^@{[$self->myzone]}") {
    $self->send("You don't have permission to save that zone.");
    return;
  }

  if ($type eq 'obj') {
    save_objects($path);
  } elsif ($type eq 'room') {
    save_rooms($path);
  } else {
    $self->send("Sorry, I don't know how to save '$type'.");
    return;
  }
  $self->send('Okay.');
  syslog "EDIT: " . $self->name . " saved $type:$path";
} else {
  $self->send('Unsaved files:');
  foreach (keys %::DirtyFiles) {
    $self->send("  * $_\n");
  }
}
