MObject->ModFields (
  autoloads => {default => {}},
);

MObject->ModMethods (
do_autoload => sub {
  my ($self) = @_;
  my $als = $self->autoloads;
  LOADITEM: foreach (keys %$als) {
    my $existing = 0;
    foreach my $other (@{$self->contents}) {
      $existing++ if $other->prototype eq $_;
    }
    next LOADITEM if $existing >= $als->{$_}{max_existing};
    $self->add_contents(MObject->new('prototype' => $_));
  }
},
);

MObject->Commands (

'autoload' => {
  requires => [qw(immortal)],
  code => sub {
    my ($self, $args) = @_;
    my ($act, $proto) = split /\s+/, $args;
    my $obj = $self->container;
    $obj->localize_field('autoloads');
    if ($act eq '+' or $act eq 'add') {
      $obj->autoloads->{$proto} = {max_existing => 1};
      $self->send("$proto added to autoloads of " . $obj->name . ".");
    } else {
      $self->send('Do WHAT with the autoloads?');
    }
    my ($zone) = $self->container->roomname =~ m#^(.*)/[^/]+$#;
    $::DirtyFiles{"room:$zone"} = 1;
 },
},

);

if ($MLoaders::ModuleEvalContext eq 'load') {
  MScheduler->add_task(
    name => 'Autoload: Reset Zones',
    hook => sub {
      MScheduler->reset_me(60*30); # every half-mud-hour
      foreach my $zone (MZone->all_zones) {
        next unless $zone->file_loaded('room');
        my $rm = $zone->info('reset_mode') || 'always';
        my $rt = $zone->info('reset_time') or return;
        my $lr = $zone->info('last_reset') || 0;
        
        next if $rm eq 'never';
        next if $lr + parse_time($rt) > MScheduler->mudclock();
        mudlog "Auto zone reset: ". $zone->path;
        $zone->all_things('room')->do_autoload();
        $zone->info('last_reset', MScheduler->mudclock());
      }
    },
  );
} else {
  MScheduler->remove_task('Autoload: Reset Zones');
}