MObject->ModFields(
  'glance_contents' => {default => 0},
  enter_prep => {default => 'in'},
  sky_vis => {default => 1}, # fraction of sunlight that gets to this room - e.g. dense forest might use .1
  doing => {default => '', nostore => 1},
  do_stop => {default => sub {}, nostore => 1},
);


MObject->Commands (
look => {
  basic => 1,
  requires => [],
  code => sub {
my ($self, $args) = @_;
MLoaders->mloaded('body_pos') and $self->bp_assert('look', 'look');
if ($args and $args !~ /^(a?round|a?bout|room|BRIEF)$/i) {
  $args =~ s/^(at?|in?)\s+//;
  my $lookin = $1 ? $1 =~ /i/ : 0;
  #$self->send("DEBUG: before object_find");
  my $obj = $self->object_find($args, extra_descs => 1);
  #$self->send("DEBUG: after object_find");
  if (not ref $obj) {
    # it's an extra desc
    $self->send($obj);
    return 1;
  }
  $self->act(undef,
     ($obj->name ? "@{[$self->name]} looks at @{[$obj->name]}." : ''),
             "@{[$self->name]} looks at you.",
             $obj) unless $obj == $self or $obj->container == $self;
  $self->do_page($self->desc_gen($obj->ldesc, self => $obj)) if !$lookin; # FIXME: ought to put all stuff in buffer

  if ($obj->cnt_interior) {
    $self->send($obj == $self ? "&c;You are carrying:&n;" : "&c;Contained by " . $obj->name . ":&n;");
    my $had = 0;
    foreach (@{$obj->contents}) {
      next if !$self->can_see($_);
      $had++;
      $self->send(
        '&fg;'
        . $_->name
        . '&n'
        . ($_->is_slot ? ' (' . $_->is_slot . ')': '')
      );
    }
    $had or $self->send('  Nothing.');
  }
} else {
  my $inside = $self->container or do {
    $self->send("You see nothing at all.");
    return;
  };
  
  $inside = $inside->container while $inside->glance_contents and $inside->container;
  
  if (!$inside or !$self->can_see($inside)) {
    $self->send("You see nothing at all.");
    return;
  }
  
  if ($args =~ /^(a?round|a?bout)$/i) {
    my $lroundsub = sub {
      my ($room) = @_;
      my $buf = '';
      my @objects;
      foreach (grep $_->name ne $self->name, @{$room->contents}) {
        push @objects, (
          ($_->has_metabolism ? '&fy;' : '&fg;') # FIXME
          . $_->name
          . "&n\n"
        );
      }
      my (%seen, @obj_grp);
      for (my $i = 0; $i < @objects; $i++) {
        $seen{$objects[$i]}++ and next;
        push @obj_grp, $objects[$i];
      }
      foreach (@obj_grp) {
        $buf .= "   " . ($seen{$_} > 1 ? sprintf('[%2d] ', $seen{$_}) : '') . $_;
      }
      return $buf;
    };
    # FIXME: look around needs checks for max vision distance, light level.
    my $buf = "You look around and see:\n";
    $buf .= "here:\n" . $lroundsub->($inside);
    foreach my $dir (qw(north northeast east southeast south southwest west northwest up down)) {
      my $dist = 0; my $nroom = $inside; my ($exit, %seen);

      while ($exit = $nroom->exits->{$dir} 
             and $nroom = $::Rooms{$exit->{to}}
             and !$exit->{minor}
             and !$seen{$nroom}
      ) {
        $dist++;
        if ($exit->{closed}) {
          $buf .= $dist." room".($dist==1 ? ' ' : 's ').$dir
            . ($exit->{door} ? ": " . $exit->{door}: '') . "\n";
        } else {
          my $stuff = $lroundsub->($nroom);
          $buf .= $dist." room".($dist==1 ? ' ' : 's ').$dir
            . ($exit->{door} ? ", through " . $exit->{door}: '') . ":\n$stuff"
            if $stuff;
        }
        $seen{$nroom}++;
      }
    }
    $self->do_page($buf);
  } else {
    my ($left, $right) = ('', '');
    my $center = " &c;" . ucfirst(($inside->roomname ? '' : $inside->enter_prep . " ") . $inside->name) . "&b; ";
    if ($self->nonplayer()) {
      my $name = $inside->roomname || $inside->prototype;
      $name = 'n/a' unless defined $name;
      $left = "[$name] ";
      #$right = $attr ? " [$attr]" : '';
    }

    my $wid = ($self->connection ? $self->connection->scr_width : 80);
    my $header = '-' x $wid;
    substr($header, 0, length($left)) = $left if $left;
    substr($header, -length($right)) = $right if $right;
    substr($header, ($wid - length($center) + 6) / 2, length($center) - 6) = $center;

    my $image = '';
    if (MLoaders->mloaded('roomexits')) {
      my %exlist = map {$_, 1} keys %{$self->container->exits};
      $image = ($exlist{northwest} ? ' \'': '  ') .
               ($exlist{north}     ? '|' : ' ') .
               ($exlist{northeast} ? '/ ' : '  ') . " \n".
               ($exlist{west}      ? '--' : '  ') .
               (
                 $exlist{up} ? ($exlist{down} ? '*' : '>')
                             : ($exlist{down} ? '<' : '+')
               ) .
               ($exlist{east}      ? '--' : '  ') . " \n".
               ($exlist{southwest} ? ' /' : '  ') .
               ($exlist{south}     ? '|' : ' ') .
               ($exlist{southeast} ? '\' ': '  ') . " \n";
    }

    my $idesc = ($args eq 'BRIEF' and $self->connection and $self->connection->pref('brief')) ? ''
      : "   " . $self->desc_gen($inside->idesc, 'self' => $inside) . "\n";
    $idesc =~ s/\n{2,}\Z/\n/g;
    my $buf = "\n&b;$header&n;\n" . $self->connection->format_wrap($idesc, picture => $image);
    $buf .= join "\n", call_hooks('look_inside_extra_info', $inside, $self);

    my @objects;
    foreach (grep $_->name ne $self->name, @{$inside->contents}) {
      push @objects, (
        ($_->has_metabolism ? '&fy;' : '&fg;') # FIXME
        . $_->desc_in_room($self)
        . "&n\n"
      ) if $self->can_see($_);
    }
    my (%seen, @obj_grp);
    for (my $i = 0; $i < @objects; $i++) {
      $seen{$objects[$i]}++ and next;
      push @obj_grp, $objects[$i];
    }
    foreach (@obj_grp) {
      $buf .= ($seen{$_} > 1 ? sprintf('[%2d] ', $seen{$_}) : '') . $_;
    }
    $self->do_page($buf);
  }
}
  },
},
  inventory => {code => sub {$_[0]->do('look in self');}},
  quit => {
    requires => [qw(unique)],
    code => sub {
      my ($self, $args) = @_;
      mudlog($self->name . " has quit.");
      $self->act("Goodbye!", $self->name . " seems to shimmer for a moment, then vanishes completely.");
      $self->save_player();
      foreach (@{$self->contents}) {
        $_->dispose;
      }
      $self->saveable(0); # prevent dispose auto-save from wiping out objects
      $self->dispose;
    },
    help => <<'EOHELP',
Saves your character and removes it from the game, including everything you're carrying.
EOHELP
  },
  alias => {code => sub {$_[0]->connection->do_alias_cmd($_[1])}, help => <<'EOHELP'},
alias
alias <word> <commands>
alias <word>

Aliases allow you to substitute short commands for long ones, e.g. "kw" becomes "kill wolf".

You can make use of arguments to the alias by the replacements '$0' through '$9'. $0 is the entire argument string, and $1-$9 are individual words. You can also use $*&c;<n>&n; to get all the words from &c;<n>&n; to the end of the line, where &c;<n>&n; is a number from 1 to 9.

Examples:

> &y;alias bsay emote says boredly, '$0'&n
Set alias.
> &y;bsay So what?&n
Marn says boredly, 'So what?'
EOHELP
stop => {code => sub {
  my ($self, $args) = @_;
  if ($self->do_stop->($self)) {
    $self->nact("<self.name> stop<self.is!s> ".$self->doing.".");
    $self->reset_val('doing');
    $self->reset_val('do_stop');
  }
}},
);

my $isin = sub {
  my ($thing, $ary) = @_;
  foreach (@$ary) {
    return 1 if $_ == $thing;
  }
  return 0;
};

MObject->CommandAliases(
  look => [qw(examine read)],
);

MObject->ModMethods(
  
desc_in_room => sub {
  my ($self, $viewer) = @_;
  
  my $name_with_mods = sub {
    my ($obj) = @_;
    my $c;
    my $flstr = (
        ( (!$obj->connection and $obj->unique)                          ? ' (linkless)'  : '')
      . ( $obj->invisible                                               ? ' (invisible)' : '')
      . ( ($c = $obj->connection and $c->isa('MConnection::Capturing')) ? ' (logging)'   : '')
    );
    return $obj->name . $flstr;
  };

  my $hasbp = MLoaders->mloaded('body_pos') && $self->has_body_pos;
  if (@{$self->contents} and $self->glance_contents) {
    if (@{$self->contents} > 1) {
      return ucfirst($self->name) . " is here, containing " . do {
        my $l = join(', ', map {!$viewer->can_see($_) ? () : $_ == $viewer ? 'you' : $name_with_mods->($_)} @{$self->contents});
        $l =~ s/, ([^,]+)$/ and $1/;
        $l;
      } . ".";
    } else {
      my $thing = $self->contents->[0];
      return ($thing == $viewer ? "You are" : $name_with_mods->($thing) . " is")
        . ($hasbp ? ' '.$thing->bp_desc : '')
        . " " . $self->enter_prep . " " . $self->name
        . " here" . ($thing->doing ? ", " . $viewer->desc_gen($thing->doing) : '') . ".";
    }
  }
  return ($self->invisible ? '(invisible) ' : '').$self->sdesc if ($self->has_val('sdesc') and ($hasbp ? $self->sdesc_pos eq $self->body_pos : 1));
  return
    (ucfirst $name_with_mods->($self) . " is"
    . ($hasbp ? ' '.$self->bp_desc : '')
    . " here" . ($self->doing ? ", " . $viewer->desc_gen($self->doing) : '') . ".");
},

nact => sub {
  my ($self, $desc, %objs) = @_;
  
  my %seen;
  $objs{self} = $self;
  foreach (values %objs) {
    $_->object_scan(sub {
      my ($o) = @_;
      return if $seen{$o}++;
      $o->send(ucfirst $o->desc_gen($desc, %objs));
    });
  }
},

act => sub {
  my ($self, $mestr, $theystr, $targstr, $targ) = @_;

  $self->send(ucfirst $mestr) if defined $mestr;
  $targ->send(ucfirst $targstr) if defined $targ and $targ->can_see($self);

  return unless $self->container and defined $theystr;
  my @exclude = ($self, ($targ ? $targ : ()));

  my @peers = grep !$isin->($_, \@exclude), @{$self->container->contents};
  $self->container->_gsend_from_inside($theystr, $self, (@exclude, @peers));
  foreach (@peers) {
    $_->_gsend_local($theystr, $self, @exclude);
  }
},

_gsend_local => sub {
  my ($self, $str, $source, @exclude) = @_;

  $self->send(ucfirst $str) if $self->can_see($source) and !$isin->($_, \@exclude);

  return unless $self->glance_contents;

  foreach (grep !$isin->($_, \@exclude), @{$self->contents}) {
    $_->_gsend_local(($self->glance_contents ? $str : "outside, $str"), $source, @exclude);
  }
},

_gsend_from_inside => sub {
  my ($self, $str, $source, @exclude) = @_;
  # Things happening inside an object are visible to that object, but not to
  # other objects unless the object is ->glance_contents

  $self->send("Inside, $str") if $self->can_see($source);
  
  return unless $self->container and $self->glance_contents;
  
  $self->container->_gsend_from_inside($str, $source, @exclude);
  
  foreach (grep !$isin->($_, \@exclude), @{$self->container->contents}) {
    $_->_gsend_local(($self->glance_contents ? $str : $self->enter_prep ." ". $self->name . ", $str"), $source, @exclude);
  }
},

echo_to_contents => sub {
  my ($self, $str) = @_;

  foreach (@{$self->contents}) {
    $_->_gsend_local($str);
  }
},


desc_gen => sub {
  my ($self, $str, %objs) = @_;

  $objs{viewer} = $self;
  if ($str !~ /</) {
    $str = "<self.vis?".$self->dg_escape($str).">";
  }
  return $self->_dg_parse(\$str, \%objs);
},


_dg_parse => sub {
  my ($viewer, $str, $objs) = @_;

  my $out = '';
  while (length $$str) {
    $$str =~ s/^([^<>:]*)//;
    $out .= $1;
    last unless length $$str and $$str !~ /^[:>]/;
    #print "DEBUG: before tag match, str='$$str'\n";
    $$str =~ s/^<([#\w]+)\.(\w+)// or $out .= "[parse error: badly formed tag]$$str", goto DONE;
    my ($olabel, $field) = ($1, $2);
    #exists $$objs{$olabel} or die "parse error: undefined object label '$olabel'";
    if ($$str =~ s/^>//) {
      $out .= $viewer->_dg_field($$objs{$olabel} || $olabel, $field);
    } elsif ($$str =~ s/^([?!])//) {
      my $notflag = $1 eq '!' ? 1 : 0;
      my $yestr = $viewer->_dg_parse($str, $objs);
      $$str =~ s/^([:>])// or $out .= "[parse error: badly formed <?:> - no : or > found after ?]$$str", goto DONE;
      my $nostr;
      if ($1 eq '>') {
        $nostr = '';
      } else {
        $nostr = $viewer->_dg_parse($str, $objs);
        $$str =~ s/^>// or $out .= "[parse error: badly formed <?:> - no > found after :]$$str", goto DONE;
      }
      $out .= ($viewer->_dg_field($$objs{$olabel} || $olabel, $field) > 0 xor $notflag) ? $yestr : $nostr;
    } else {
      $out .= "[parse error: unknown tag type]<$olabel.$field$$str";
    }
  }
  DONE: return $out;
},

_dg_field => sub {
  my ($viewer, $obj, $field) = @_;

  if (not ref $obj) {
    if ($obj =~ /^#(.*)$/) {
      $obj = MObject->obj_id($1) or return "[MISSING]";
    } else {
      return "[error: undefined object label: $obj]";
    }
  }

  #print "in _dg_field, viewer $viewer, obj $obj, field $field\n";
  if ($field eq 'name') {
    return $obj == $viewer ? 'you' : $viewer->can_see($obj) ? $obj->name : 'something';
  } elsif ($field eq 'rootname') {
    my $name = $obj->name;
    $name =~ s/^(an?|the)\s+//;
    return $viewer->can_see($obj) ? $name : 'something';
  } elsif ($field eq 'pname') {
    return $obj == $viewer ? 'your' : $viewer->can_see($obj) ? ($obj->name."'s") : "something's";
  } elsif ($field eq 'is') {
    return $obj == $viewer ? 1 : 0;
  } elsif ($field eq 'vis') {
    return ($obj == $viewer or $viewer->can_see($obj)) ? 1 : 0;
  } elsif ($field eq 'aud') {
    return ($obj == $viewer or $viewer->can_hear($obj)) ? 1 : 0;
  } elsif ($field eq 'gendern') {
    return $obj == $viewer ? 'you' : $GENDER_NOM{$obj->gender};
  } elsif ($field eq 'gendero') {
    return $obj == $viewer ? 'yourself' : $GENDER_OBJ{$obj->gender};
  } elsif ($field eq 'genderp') {
    return $obj == $viewer ? 'your' : $GENDER_POSS{$obj->gender};
  } else {
    return $obj->$field();
  }
},

dg_escape => sub {
  my ($self, $str) = @_;
  my %ttab = (
    '<' => '&lt;',
    '>' => '&gt;',
    ':' => '&colon;',
  );
  $str =~ s/([<>:])/$ttab{$1}/g;
  $str;
},

);

MLoaders->Hooks (
new_protoed_object => sub {
  my ($self) = @_;
  if ($self->m_hit !~ /^\d+$/) {
    $self->m_hit(dice($self->m_hit));
  }
},
new_unique_setup => sub {
  my ($self) = @_;
  $self->c_hit($self->m_hit);
  $self->c_move($self->m_move);
  $self->food(24000);
  $self->water(24000);
},
place_unique => sub {
  my ($self) = @_;
  $self->reset_val('doing');
  $self->reset_val('do_stop');
  $self->reset_val('offers');
},
);
