my %handlers = (
  'width' => sub {
    my ($self, $value) = @_;
    if ($value) {
      $value = 12 if $value < 12;
      $value = 400 if $value > 400;
      $self->connection->pref(scr_width => $value);
      $self->send("Your screen width is now $value.\n");
    } else {
      $self->send("Your screen width is @{[$self->connection->scr_width]}.\n");
    }  
  },
  'height' => sub {
    my ($self, $value) = @_;
    if ($value) {
      $value = 4 if $value < 4;
      $value = 2000 if $value > 2000;
      $self->connection->pref(scr_height => $value);
      $self->send("Your screen height is now $value.\n");
    } else {
      $self->send("Your screen height is @{[$self->connection->scr_height]}.\n");
    }  
  },
  'color' => sub {
    my ($self, $value) = @_;
    my $t;
    if ($value) {
      $t = 1 if $value =~ /on|1|true|yes|complete/;
      $t = 0 if $value =~ /off|0|false|no/;
    }
    if (defined $t) {
      $self->connection->pref(color => $t);
      $self->send("Color is now @{[$t ? 'on' : 'off']}.\n");
    } else {
      $self->send(qq{Color is @{[$self->connection->pref('color') ? 'on' : 'off']}.\n});
    }
  },
  'brief' => sub {
    my ($self, $value) = @_;
    my $t;
    if ($value) {
      $t = 1 if $value =~ /on|1|true|yes/;
      $t = 0 if $value =~ /off|0|false|no/;
    }
    if (defined $t) {
      $self->connection->pref(brief => $t);
      $self->send("Brief-look mode is now @{[$t ? 'on' : 'off']}.\n");
    } else {
      $self->send(qq{Brief-look mode is @{[$self->connection->pref('brief') ? 'on' : 'off']}.\n});
    }
  },
  'prompt' => sub {
    my ($self, $value) = @_;
    my $t;
    if ($value) {
      $t = 1 if $value =~ /on|1|true|yes/;
      $t = 0 if $value =~ /off|0|false|no/;
    }
    if (defined $t) {
      $self->connection->pref(noprompt => !$t);
      $self->send("Prompts are now @{[$t ? 'on' : 'off']}.\n");
    } else {
      $self->send(qq{Prompts are @{[!$self->connection->pref('noprompt') ? 'on' : 'off']}.\n});
    }
  },
  'combine' => sub {
    my ($self, $value) = @_;
    my $t;
    if ($value) {
      $t = 1 if $value =~ /on|1|true|yes/;
      $t = 0 if $value =~ /off|0|false|no/;
    }
    if (defined $t) {
      $self->connection->pref(combine_output => $t);
      $self->send("Duplicate output will@{[$t ? '' : ' not']} be combined.\n");
    } else {
      $self->send("Duplicate output is@{[$t ? '' : ' not']} being combined.\n");
    }
  },
);

my $get_cmd_help = sub {
  my ($cmd) = @_;
  my $buf = "&c;- Command '$cmd'&n;\n";
  my $aka = join ', ', $self->cmdi_aliases($cmd);
  $buf .= "&c;Also known as: $aka&n;\n" if $aka;
  if ($self->nonplayer) {
    $buf .= "&c;Requires: " . (join ', ', $self->cmdi_requires($cmd)) . "&n;\n";
  }      
  $buf .= $self->cmdi_help($cmd) || 'No help is available for this command.';
  return $buf;
};

MObject->Commands (
  cpref => {code => sub {
    my ($self, $args) = @_;
    my ($field, $value) = split /\s+/, $args;

    if (!$field) {
      $self->send("Connection preferences:");
      foreach (keys %handlers) {
        $self->connection->send_str("($_) "); # ugly
        $handlers{$_}->($self);
      }
      return;
    } else {
      ($handlers{$field} || sub {$self->send("Sorry, I don't know what that is.")})->($self, $value);
    }
  }, help => <<'EOHELP'},
cpref [ width | height | color | brief | prompt | combine ] [&g<value>&n]

For viewing and setting connection options. Use "&y;cpref <field>&n" to see the current value, "&y;cpref <field> <value>&n" to change it, or "&y;cpref&n;" by itself to see all preferences.

Values are:
  &y;width&n; (number): Terminal width
  &y;height&n; (number): Terminal height
  &y;color&n; (toggle): Color on
  &y;brief&n; (toggle): Brief mode - moving into a room will not display its description.
  &y;prompt&n; (toggle): Display a prompt.
  &y;combine&n; (toggle): Combines duplicate output lines. Turning this on may slow down the server.
EOHELP
  who => {code => sub {
    my ($self, $args) = @_;

    my $buf = '';
    $buf .= "&c;Players currently connected:&n;\n";
    foreach (sort {$b->id <=> $a->id} values %MConnection::Connections) {
      my $po = $_->object;
      next unless $po;
      $buf .= sprintf "  %s%s&n;%s\n", $po->name, $po->title, ($po->immortal ? " (Immortal)" : "");
    }
    $self->do_page($buf);
  }},
  xhelp => {code => sub {
    my ($self, $args) = @_;

    my $ahelp;
    my @matches;

    if (!$args) {
      push @matches, "info basic";

    } elsif (exists $::ImmHelp{lc $args}) {
      $self->connection->do_page(${$::ImmHelp{lc $args}});
    } elsif (($ahelp) = grep /^\Q$args/i, keys %::ImmHelp) {
      $self->connection->do_page(${$::ImmHelp{$ahelp}});

    } elsif (exists $::Help{lc $args}) {
      $self->connection->do_page(${$::Help{lc $args}});
    } elsif (($ahelp) = grep /^\Q$args/i, keys %::Help) {
      $self->connection->do_page(${$::Help{$ahelp}});

    } elsif ((my $cmd) = $self->cmd_match($args)) {
      my $buf = "&c;- Command '$cmd'&n;\n";
      my $aka = join ', ', $self->cmdi_aliases($cmd);
      $buf .= "&c;Also known as: $aka&n;\n" if $aka;
      if ($self->nonplayer) {
        $buf .= "&c;Requires: " . (join ', ', $self->cmdi_requires($cmd)) . "&n;\n";
      }      
      $buf .= $self->cmdi_help($cmd) || 'No help is available for this command.';
      $self->do_page($buf);
    } elsif ($args eq '-r') {
      MLoaders->load_help;
    } else {
      $self->send("No help entry for '$args'.");
      mudlog "KEYWORD: help '$args'";
    }
  }},
  help => {code => sub {
    my ($self, $args) = @_;

    if ($args eq '-r') {
      MLoaders->load_help;
      $self->send("Done.");
      return;
    }

    my $ahelp;
    my @matches;

    if (!$args) {
      push @matches, "info basic";
    }

    if ($self->immortal) {
      foreach (grep /^\Q$args/i, keys %::ImmHelp) {
        push @matches, "imm $_";
      }
    }

    foreach (grep /^\Q$args/i, keys %::Help) {
      push @matches, "info $_";
    }

    if ((my $cmd) = $self->cmd_match($args)) {
      push @matches, "command $cmd";
    }

    if (@matches == 1) {
    } elsif (@matches) {    
    } else {
      $self->send("No help entry for '$args'.");
      mudlog "KEYWORD: help '$args'";
    }
  }},
  commands => {
    code => sub {
      my ($self, $args) = @_;
      $self->send("The commands available to you are:");
      $self->do_multicol($self->commands_for_display);
    },
  },
  title => {
    code => sub {
      my ($self, $args) = @_;
      $args = " $args" if $args =~ /^\w/;
      $self->title($args);
      $self->send("Okay, you're now " . $self->name . $self->title . ".\n");
    },
  },
  report => {code => sub {
    my ($self, $args) = @_;
    
    my ($type, $str) = split /\s+/, $args, 2;
    $type or do {
      $self->send("What do you want to report?");
      return;
    };
    $type =~ /^(bug|idea|typo|note|gripe)$/i or do {
      $self->send("You must specify a report type of bug, idea, typo, note, or gripe.");
      return;
    };
    mudlog uc($type) . " REPORT: " . $self->name . " at " . ($self->container->roomname || ($self->container->name . "#" . $self->container->id)) . ": $str";
  }, help => <<'EOHELP'},
report bug|idea|typo|note|gripe &g;<message>&n;

This command is used to report problems and ideas to the administration. Your &g;<message>&n; is logged, together with the room which you are in.

If you're not sure what type of report you have, use these examples as a guideline:
  bug - "Hey! All my items are gone!"
  idea - "It would be cool if..."
  typo - "These room descriptions are awful!"
  note - "Is this spell really supposed to work better indoors?"
  gripe - "Armor gets damaged way too fast."
EOHELP
  think => {code => sub {$_[0]->send($_[1])}},
);

MObject->CommandAliases (
  cpref => [qw(config toggles)],
);
