MObject->ModFields (
  voluntary_carry => {default => 0},
  squirmy => {default => 0},
  food_value => {default => 0},
  display_desc => {default => "<holder.vis?<self.vis?<holder.name> display<holder.is!s> <holder.genderp> <self.rootname>.>>"},
  offers => {default => [], nostore => 1},
);

MObject->Commands (
'drop' => {
  requires => [qw()],
  code => sub {
    my ($self, $args) = @_;
    MLoaders->mloaded('body_pos') and $self->bp_assert('reach_inventory');
    if ($args) {
      my $had = 0;
      foreach my $obj ($self->object_find($args, no_outside => 1)) {
        $had++;
        $self->act("You drop @{[$obj->name]}.",
                   "@{[$self->name]} drops @{[$obj->name]}.",
                   "@{[$self->name]} drops you.",
                   $obj);
        $obj->container->remove_contents($obj);
        $self->container->add_contents($obj);
      } 
      if (!$had) {
        $self->send("You don't seem to have @{[  $args=~/^[aeiou]/ ? 'an' : 'a'  ]} $args.\n");
      }
    } else {
      $self->send('Drop what??');
    }
  },
},
'get' => {
  requires => [qw()],
  basic => 1,
  code => sub {
    my ($self, $args) = @_;
    MLoaders->mloaded('body_pos') and $self->bp_assert('reach_object');
    $args or do {
      $self->send('Get what??');
      return;
    };
    my $source;
    my ($thing, $from) = split /\s+from\s+/, $args;
    if (!$from) {
      $thing = $args;
      if (!$self->object_find($thing)) {
        ($thing, $from) = split /\s+/, $args;
      }
    }
    if ($from) {
      $source = $self->object_find($from);
      if (!$source) {
        $self->send("You don't see a $from here.");
        return;
      }
      if ($source->voluntary_carry) {
        $self->send("You can't do that.");
        return;
      }
    } else {
      $source = $self;
    }
    my ($had, $good, $obj) = 0;
    foreach $obj ($source->object_find($thing, 'caller' => $self, extra_descs => 1, ($from ? (no_outside => 1) : (no_self_contents => 1)) )) {
      next if $obj == $self;
      $had++;
      next if not ref $obj; # it's an extra desc, skip it, see "if ($had == 1" below for relevant code
      if ($obj == $self->container) {
        $self->send(ucfirst $obj->name . ": you can't pick up what you're in!");
        next;
      }
      if (!$self->can_contain($obj)) {
        my $cont = '';
        if (@{$obj->contents}) {
          my $l = join(', ', map {$_->name} @{$obj->contents});
          $l =~ s/, ([^,]+)$/, and $1/;
          $cont = " (containing $l)";
        }
        $self->send(ucfirst $obj->name . $cont . ": $GENDER_NOM{$obj->gender}'s too big for you to carry.");
        next;
      }
      if ($obj->squirmy) {
        my $chance = ($self->dex - $obj->dex) / 18 + .5;
        if (rand > $chance) {
          $self->act("@{[$obj->name]} squirms out of your grasp!",
                     "@{[$obj->name]} squirms out of @{[$self->name]}'s grasp!",
                     "You avoid @{[$self->name]}'s grasp!",
                     $obj); 
          next;
        }
      }
      $self->nact("<self.name> get<self.is!s> <obj.name>.", obj => $obj);
        # FIXME: ought to have somw way of saying "display this only if self OR obj is visible".
      $obj->move_into($self);
      $good = 1;
    } 
    if (!$had) {
      $self->send("You do not see that here.");
      return;
    }
    if (!$good and $had == 1 and not ref $obj) {
      $self->send("You can't get that.");
    }
  },
},
'give' => {
  requires => [qw()],
  code => sub {
    my ($self, $args) = @_;
    
    my ($objname, $toname) = split /\s+to\s+|\s+/, $args, 2;
    
    my $to = $self->object_find($toname) or do {
      $self->send("Give $objname to WHO?");
      return;
    };

    $to->voluntary_carry or die "CFAIL:You can't do that. Try 'put'.";
        
    $self->doing and die "CFAIL:You're busy ".$self->desc_gen($self->doing).".";

    $to->can_see($self) or die "CFAIL:You hold it out, but $GENDER_NOM{$to->gender} doesn't notice you.";

    my @offered = $self->object_find($objname, no_outside => 1);
    my @offid = map $_->id, @offered;
    my $selfid = $self->id;
    my $toid = $to->id;
    my $offname = join ', ', map "<#$_.name>", @offid;

    $self->nact("<self.name> offer<self.is!s> $offname to <to.name>.", to => $to);
    $self->doing("offering $offname to <#".$to->id.".name>");
    $self->do_stop(sub {
      my $ito = MObject->by_id($toid);
      @{$ito->offers} = grep {$_->{name} ne $offname} @{$ito->offers};
      1;
    });
    $to->localize_field('offers');
    push @{$to->offers}, {
      name => $offname,
      'accept' => sub {
        my ($iself) = @_;
        my $ifrom = MObject->by_id($selfid);
        foreach (@offid) {
          my $obj = MObject->by_id($_) or next;
          if (!$iself->can_contain($obj)) {
            $iself->send(ucfirst $obj->name . ": $GENDER_NOM{$obj->gender}'s too big for you to carry.");
            $ifrom->send(ucfirst $ifrom->desc_gen("<to.name> can't hold <obj.name>.", to => $iself, obj => $obj)) if $ifrom;
            next;
          }
          $iself->nact("<self.name> take<self.is!s> <obj.name> from <#$selfid.name>.", obj => $obj);
          $obj->move_into($iself);
        }
        $ifrom or return;
        $ifrom->reset_val('doing');
        $ifrom->reset_val('do_stop');
      },
      deny => sub {
        my ($iself) = @_;
        $iself->nact("<self.name> reject<self.is!s> $offname.");
        my $ifrom = MObject->by_id($selfid) or return;
        $ifrom->reset_val('doing');
        $ifrom->reset_val('do_stop');
      },
      failed => sub {
        my ($iself) = @_;
        my $ifrom = MObject->by_id($selfid) or return;
        $ifrom->reset_val('doing');
        $ifrom->reset_val('do_stop');
      },
    };

  },
},
'put' => {
  requires => [qw()],
  code => sub {
    my ($self, $args) = @_;
    
    my ($objname, $toname) = split /\s+(?:in|on|under)\s+|\s+/, $args, 2;
    
    my $to = $self->object_find($toname);

    $to->voluntary_carry and die "CFAIL:You can't do that. Try 'give'.";
    
    foreach my $obj ($self->object_find($objname, no_outside => 1)) {
       if (!$to->can_contain($obj)) {
        $self->send(ucfirst $obj->name . ": $GENDER_NOM{$obj->gender}'s too big for @{[$to->name]} to hold.");
        next;
      }
      $self->nact("<self.name> put<self.is!s> <obj.name> <to.enter_prep> <to.name>.", to => $to, obj => $obj);
      $obj->move_into($to);
    } 

  },
},
'enter' => {
  code => sub {
    my ($self, $args) = @_;
    
    my $hasbp = MLoaders->mloaded('body_pos');
    if (!$args) {
      $self->send("Enter what??");
      return;
    }
    $hasbp and $self->bp_assert('reach_object') and $self->bp_assert('move');
    my $obj = $self->object_find($args);
    if ($obj->has_metabolism) {
      $self->send("Hey!");
      return;
    }
    my $c = $obj;
    while ($c) {
      if ($c == $self) {
        $self->send("You can't enter something that you're carrying.");
        return;
      }
      $c = $c->container;
    }
    if (!$obj->can_contain($self)) {
      $self->send(ucfirst $obj->name . " doesn't have room for you.");
      return;
    }
    $self->act("You enter @{[$obj->name]}.",
               "@{[$self->name]} enters @{[$obj->name]}.",
               "@{[$self->name]} enters.",
               $obj);
    $self->move_into($obj);
    $self->pause_commands(2);
  },
},
leave => {
  code => sub {
    my ($self, $args) = @_;
    
    my $hasbp = MLoaders->mloaded('body_pos');
    $hasbp and $self->bp_assert('reach_object') and $self->bp_assert('move');

    my $pcon;
    unless ($pcon = $self->container) {
      $self->send("You aren't inside anything! How can you leave??");
      return;
    }

    my $obj = $pcon->container;
    if (!$obj) {
      $self->send("There's nothing to leave to.");
      return;
    }
    if (!$obj->can_contain($self)) {
      $self->send("There's no room for you to get out of " . $pcon->name . ".");
      return;
    }

    $self->act("You leave @{[$pcon->name]}.",
               "@{[$self->name]} leaves @{[$pcon->name]}.");
    $self->container->remove_contents($self);
    $obj->add_contents($self);
    $self->act(undef, "@{[$self->name]} gets out of @{[$pcon->name]}.");
    $self->pause_commands(2);
  },
},
'use' => {
  code => sub {
    my ($self, $args) = @_;
    MLoaders->mloaded('body_pos') and $self->bp_assert('reach_inventory');
    my ($had, $time) = (0, 0);
    foreach my $obj ($self->object_find($args, no_outside => 1)) {
      $had++;
      $time += 1;
      if ($self->slot_add($obj, show_error => 1)) {
        $self->act("You wear @{[$obj->name]}.",
                   "@{[$self->name]} wears @{[$obj->name]}.",
                   "@{[$self->name]} wears you.",
                   $obj);
        $time += $obj->total_volume;
      }
    } 
    if (!$had) {
      $self->send("You don't seem to have @{[  $args=~/^[aeiou]/ ? 'an' : 'a'  ]} $args.\n");
    }
    $self->pause_commands($time + 5);
  },
},
remove => {
  code => sub {
    my ($self, $args) = @_;
    MLoaders->mloaded('body_pos') and $self->bp_assert('reach_inventory');
    my ($had, $time) = (0, 0);
    foreach my $obj ($self->object_find($args, no_outside => 1)) {
      $had++;
      $time += 1;
      if ($self->slot_remove($obj, show_error => 1)) {
        $self->act("You take off @{[$obj->name]}.",
                   "@{[$self->name]} takes off @{[$obj->name]}.",
                   "@{[$self->name]} takes you off.",
                   $obj);
        $time += $obj->total_volume;
      }
    } 
    if (!$had) {
      $self->send("You don't seem to be using @{[  $args=~/^[aeiou]/ ? 'an' : 'a'  ]} $args.\n");
    }
    $self->pause_commands($time + 5);
  },
},
'eat' => {
  requires => [qw()],
  code => sub {
    my ($self, $args) = @_;
    MLoaders->mloaded('body_pos') and $self->bp_assert('reach_inventory', 'eat');

    $args or do {
      $self->send("Eat what?");
      return;
    };
    if (my $obj = $self->object_find($args, no_outside => 1)) {
      if (!$obj->food_value) {
        $self->send("@{[$obj->name]} doesn't look edible.");
        return;
      }
      $self->food($obj->food_value);
      $self->act("You eat @{[$obj->name]}.", 
                 "@{[$self->name]} eats @{[$obj->name]}.",
                 "@{[$self->name]} eats you.",
                 $obj);
      $obj->dispose;
    } else {
      $self->send("You don't seem to have a $args.");
    }
  },
},
display => {
  code => sub {
    my ($self, $args) = @_;
    MLoaders->mloaded('body_pos') and $self->bp_assert('reach_inventory');
    foreach my $obj ($self->object_find($args, no_outside => 1)) {
      $obj->nact($obj->display_desc, 'holder' => $self);
    } 
  },
},
'accept' => {code => sub {
  my ($self, $args) = @_;
  my $offer = shift @{$self->offers};
  $offer or die "CFAIL:There's nothing to accept!";
  $offer->{'accept'}->($self);
}},
deny => {code => sub {
  my ($self, $args) = @_;
  my $offer = shift @{$self->offers};
  $offer or die "CFAIL:There's nothing to deny!";
  $offer->{'deny'}->($self);
}},
);

MObject->CommandAliases(
  get => [qw(take)],
  'use' => [qw(wear wield hold grab)],
  remove => [qw(unwear unwield)],
  leave => [qw(out exit)],
  display => [qw(show brandish)],
);

MObject->ModMethods(
can_contain => sub {
  my ($self, $other) = @_;
  my $total = $other->total_volume;
  my $noslot = $self->cnt_slot_nomax;
  foreach (@{$self->contents}) {
    $total += $_->total_volume unless $noslot and $_->is_slot;
  }
  return ($total <= $self->cnt_interior);
},

);
