MObject->Fields (
  cnt_maxweight => {default => -1},
  cnt_wfail_msg => {default => '<self.name> breaks due to <self.genderp> load!'},
  cnt_wfail_type => {default => 'pieces'},
  cnt_wwarn_msg => {default => '<self.name> creaks under <self.genderp> load.'},
);

MLoaders->Hooks (
cnt_weight_change => sub {
  my ($self, $changeby) = @_;
  
  #mudlog "DEBUG: in cnt_weight_change for ".$self->name;
  return if $changeby <= 0;
  return if $self->cnt_maxweight < 0;
  my $weight = $self->total_weight - $self->weight;
  return unless $weight > $self->cnt_maxweight * .80;
  if ($weight > $self->cnt_maxweight) {
    $self->nact($self->cnt_wfail_msg);
    &{{
      'pieces' => sub {
        mudlog "DEBUG: in pieces routine";
        my $pcs = MObject->new(
          name => "the broken pieces of " . $self->name,
          invisible => $self->invisible,
          weight => $self->weight,
          volume => $self->total_volume * 1.3,
          glance_contents => 1,
        );
        $pcs->add_contents(@{$self->contents});
        my $into = $self->container;
        $self->dispose;
        $pcs->move_into($into);
      },
    }->{$self->cnt_wfail_type} || sub {mudlog "#".$self->id." has bad weight fail type!"}};
  } else {
    $self->nact($self->cnt_wwarn_msg);
  }
},
);

