Require 'editing';

Define Fields => {
  def_list_path => {default => []},
};

Define Commands => {
'ls' => {
  requires => [qw(watcher)],
  no_options => 1,
  code => sub {
    my ($self, $args) = @_;
    
    $args =~ s#(.)/$#$1#;
    my @thing = MDefList->path(($args !~ m#^/# ? @{$self->def_list_path} : ()), $args);
    my $thing = $thing[0];
    if (not blessed($thing, 'MDefList')) {
      return [report=>{},
        [title=>{}, ('/' . join '/', @{$self->def_list_path}, $args)],
        ['html:ul'=>{}, map ['html:li'=>{},$_], @thing],
      ];
    }
    [report=>{},
      [title=>{}, ('/' . join '/', @{$self->def_list_path}, $args)],
      ['html:ul'=>{'html:class'=>'report'}, map {['html:li'=>{}, &{sub{
        my @val = $thing->get($_);
        my @src = sort $thing->get_source($_);
        my $label = join('', map substr($_,0,1), @src) . ' ' . $_;
        $label .= '*' if @val > 1;
        $label .= '/' if grep {ref $_ and ref $_ eq 'MDefList'} @val;
        $label;
      }}]} sort $thing->keys]
    ];
  },
},

'cd' => {
  requires => [qw(watcher)],
  code => sub {
    my ($self, $args) = @_;
    
    $self->def_list_path([MDefList->path_parse($args)]);  
    return '/' . join '/', @{$self->def_list_path};
  },
},
};
