Define '.' => {
  Help => MDefList->new(type => 'HASH'),
};

###############################################################################
Require 'commands';
###############################################################################

Define Fields => {
  help => {},
};

Define Commands => {
  help => {
    optional_object => 1,
    junk_prefixes => ['for', 'on', 'me with', 'do i', 'do', 'did'],
    aliases => [qw(how why)],
    code => sub {
      my ($obj, $args, %info) = @_;
      my $con = $info{connection};
      
      $args = 'basic' if not length $args;
      
      my $hlist = MDefList->root->get('Help');
      
      my @results = (
        (map [$_, "command $_", sub {
            my $cmdrec = MDefList->path('/Commands')->get($_[0]);
            my @aliases = @{$cmdrec->{aliases} || []};
            ['html:ul'=>{}, 
              (@aliases ? ['html:li'=>{}, 'Aliases: ' . join ', ', @aliases] : ()),
              ( $info{connection}->user && $info{connection}->user->privileged('watcher') && $cmdrec->{requires}
                  ? ['html:li'=>{}, 'Requires privileges: ' . join ', ', @{$cmdrec->{requires}}]
                  : ()
              ),
            ],
            map +(ref $_ ? $_ : ['html:p'=>{}, $_]), $cmdrec->{help};
          }],
          eval { map $_->[1], $con->cmd_match($obj, $args, no_special => 1) }
        ),
        (map [$_, scalar desc_gen('"<o>"',o=>$_), sub {
            my $thing = $_[0];
            my @items;
            while ($thing) {
              push @items, $thing->getAttr('help');
              $thing = $thing->getPrototype;
            }
            return map {ref $_ ? $_ : ['html:p'=>{}, $_]}
                   grep defined,
                   (@items, call_hooks('obj_help', $_[0]));
          }],
          eval { $obj->object_find($args, entire_world => 1, symbols => 1) }
        ),
       (map [$_, $_->{title}, sub {
            my $hitem = $_[0];
            return $hitem->{body};
          }],
          grep $_->{keywords} =~ /\Q$args/, $hlist->values
        ),
      );
      
      @results or die "CFAIL:No help available for \"$args\".";
      @results == 1 or do {
	my @things = map +(', ', $_->[1]), sort @results;
	shift @things;
	$things[-2] = ' or ' if @things > 1;
        $con->input_mode_push('help topic' => sub {
          my ($con, $input) = @_;
          $con->cmd_execute($con->object, 'help', $input);
          return 'done';
        });
	return [error=>{}, "Do you want help on ", @things, "?"];
      };
      my @item = @{$results[0]};
      
      [report=>{},
        [title=>{}, "Help on ",$item[1]],
        $item[2]->($item[0]),
      ];
    },
  },
};

Define Help => {
default => {title => 'Basic information', keywords => 'basic intro begin newbie start', body => xml2sx(<<'EOT')},
<group>
<html:p>Type "commands" for a list of all commands. Most of them should have help available by typing "help <key>&lt;command&gt;</key>".</html:p>

<html:p>The following help topics might be useful:</html:p>

<html:ul>
  <html:li>help referring</html:li>
  <html:li>help entering commands</html:li>
  <html:li>help help</html:li>
</html:ul>
</group>
EOT
};