use strict;

#my %gnom  = qw(neuter it  male he  female she plural they );
#my %gobj  = qw(neuter it  male him female her plural them );
#my %gposs = qw(neuter its male his female her plural their);

my @pronouns;

my @cases = qw(   s         o         p         pp ); my @pronoun_table = map /^\s+(.*)$/, split /\n/,<<'END';
  1     singular  I         me        my        mine
  1     plural    we        us        our       ours
  2     singular  ye        you       your      yours
  2     sing/infm thou      thee      thy       thine
  3     male      he        him       his       his
  3     female    she       her       her       hers
  3     singular  it        it        its       its
  3     plural    they      them      their     theirs
  0     singular  who       whom      whose     whose
  0     plural    who       whom      whose     whose
END

foreach (@pronoun_table) {
  my @item = split / +/;
  $pronouns[$item[0]]{$item[1]} = {map +($cases[$_], $item[$_+2]), 0..3};
}
foreach (@pronouns) {
  $_->{singular} ||= $_->{neuter};
  $_->{male} ||= $_->{singular};
  $_->{female} ||= $_->{singular};
  $_->{neuter} ||= $_->{singular};
}

Define PrefDefaults => {
  viewpoint => 2,
};

Define 'Etc' => { Pronouns => \@pronouns };

my $pick_pronoun = sub {
  my ($con, $viewer, $thing, $case) = @_;
  my $gender = $viewer->can_see($thing) ? $thing->getAttr('gender') : 'singular';
  #my $vp = ; ($vp < 3 ? $vp ^ 3 : $vp)
  return $pronouns[$viewer->id == $thing->id ? $con->pref('viewpoint') : 3]{$gender}{$case};
};

my %dg_escapes = (
  colon => ':',
  'lt' => '<', 'gt' => '>',
  'lc' => '{', 'rc' => '}',
  'lb' => '[', 'rb' => ']',
  'lp' => '(', 'rp' => ')',
);

my $dg_field = sub {
  my ($obj, $field, $pextra, $fextra) = @_;
  #mudlog "DEBUG: dg_field, obj $obj, field $field, extra ".Data::Dumper::Dumper($fextra)."\n";

  if ($field eq 'viscontext') {return $obj->vis_context->id} # FIXME: this doesn't fit
  else {return [obj=>{($obj eq 'viewer' ? (viewer => 1) : (oid => $obj->id)), part => $field, (@$fextra ? (data => [group=>{}, @$fextra]) : ())}]}
};

my $dg_parser;
$dg_parser = sub {
  my ($str, $terminator, $objs, $extra) = @_;

  my @out;
  PARSE: while (length $$str) {
  
    $$str =~ s/^([^<$terminator]*)// or warn "can't happen: non-markup match failed in dg_parser with string=$$str", last PARSE;
    push @out, $1;
    
    # if /^</ doesn't match, then we're parsing a sub-string so we return now
    last unless length $$str and $$str =~ /^</;
    
    # matching a tag
    $$str =~ s/^<// or push(@out, "[parse error: can't happen: tag match failed]$$str"), last PARSE;
 
    if ($$str =~ s/^(\w)://) {
      my $ctype = $1;
      $$str =~ s/^([^>]*)>// or push(@out, "[parse error: no > found after <$ctype:]$$str"), last PARSE;
      my $cdata = $1;
      if ($ctype eq 'e') {
        push @out, ($cdata =~ /^#(.*)$/ ? chr($1) : $dg_escapes{$cdata});
      } elsif ($ctype eq 'v') {
        my $label;
        ($cdata =~ s/^(\w+):// and $label = $1)
          or $label = $extra->{last_label}
          or push(@out, "[parse error: no second part or previous tag found for verb tag]$$str"), last PARSE;
        exists $objs->{$label} or $label eq 'viewer' or push(@out, "[error: undefined object label: $label]"), last PARSE;
        push @out, [verb=>{subj=>($label eq 'viewer' ? 'viewer' : $objs->{$label}),s=>$cdata}];
      } else {
        push(@out, "[parse error: unknown special tag type '$ctype']$$str"), last PARSE;
      }
    } else {
      $$str =~ s/^([#\w]+)// or push(@out, "[parse error: badly formed field tag]$$str"), last PARSE;
      my $label = $extra->{last_label} = $1;
 
      my $field = $$str =~ s/^\.(\w+)// ? $1 : undef;

      my $labelobj;
      $labelobj = ($label =~ /^#(.*)$/   ? ObjectByID($1)
                    : $label eq 'viewer' ? 'viewer'
                    : ($$objs{$label} or push(@out, "[error: undefined object label: $label]$$str"), last PARSE)
                  ) unless $field and $field eq 'used';

      my @fextra;
      if ($$str =~ s/^\(//) {
        # found args for field
        @fextra = $dg_parser->($str, ')', $objs, $extra);
        $$str =~ s/^\)// or push(@out, "[parse error: badly formed args - no ) after (]$$str"), last PARSE;
      }
      
      if ($$str =~ s/^>//) {
        # ordinary field tag
        $field ||= 'nphr';
        $field = ($extra->{had_reg_field_tag} ? 'o-' : 's-') . $field if $field !~ /-/;
        $extra->{had_reg_field_tag} = 1;
        push @out, $dg_field->($labelobj, $field, $extra, \@fextra);
        
      } elsif ($$str =~ s/^([?!])//) {
        # if-else tag
        my $not = $1 eq '!';
        my @yes = $dg_parser->($str, ':>', $objs, $extra);
        $$str =~ s/^([:>])// or push(@out, "[parse error: badly formed <?:> - no : or > found after ?]$$str"), last PARSE;
        my @no;
        if ($1 !~ /^>$/) {
          @no = $dg_parser->($str, '>', $objs, $extra);
          $$str =~ s/^[>}]// or push(@out, "[parse error: badly formed <?:> - no > found after :]$$str"), last PARSE;
        }
        if ($field and $field eq 'used') { # FIXME: document
          push @out, (exists $$objs{$label} xor $not) ? @yes : @no;
        } else {
          push @out, [if=>{},
            [test=>{}, $dg_field->($labelobj, $field || 'is', $extra, \@fextra)],
            [then=>{}, ($not ? @no : @yes)],
            [else=>{}, ($not ? @yes : @no)],
          ];
        }
      } else {
        push @out, "[parse error: unknown field tag type]<$label" . ($field ? ".$field" : '') . $$str;
      }
    }
  }
  return @out;
};

Unloader sub { $dg_parser = undef; }; # break sub's reference to itself

###############################################################################
Define Namespaces => {
  xlink => 'http://www.w3.org/1999/xlink',
  html  => 'http://www.w3.org/1999/xhtml',
};
###############################################################################
Define Elements => {
  Object => {
    OutProcess => sub {
      my ($obj, $viewer, $recursor, $con) = @_;
      return MDefList->path('/Elements/obj')->{OutProcess}->([obj=>{}, $obj], $viewer, $recursor, $con);
    },
  },
  acti => {
    OutProcess => sub {
      my ($sx, $viewer, $recursor) = @_;
      my $attr = $sx->[SX_ATTR];
      my $actkey = $attr->{type} . ($attr->{subtype} ? '-' . $attr->{subtype} : '');
      my %objects;
      foreach (@{$sx}[SX_CONT..$#$sx]) {
        next unless $_->[SX_ELEM] eq 'obj';
        $objects{$_->[SX_ATTR]{role}} = ObjectByID($_->[SX_ATTR]{oid});
      }
      # hmmmmm. we're doing a desc_gen for each viewpoint. this could be better. FIXME
      my $desc = MDefList->root->get('Actions')->get($actkey);
      defined $desc or $desc = "ERROR<e:colon> no description for action '$actkey'";
      length $desc or return ();
      my @sxout = $recursor->([action=>{}, [ucfirst=>{}, desc_gen(
        $desc,
        %objects,
      )]]);
      return length sx2xml(@sxout) ? @sxout : ();
    },
  },
  group => {
    OutProcess => sub {
      my ($sx, $viewer, $recursor) = @_;
      # group is special, it doesn't really exist, just for convenience in data passing
      return map $recursor->($_), @{$sx}[SX_CONT..$#$sx];
    },
  },
  ucfirst => {
    OutProcess => sub {
      my ($sx, $viewer, $recursor) = @_;
      my @newnodes = map $recursor->($_), @{$sx}[SX_CONT..$#$sx];
      return @newnodes ? [ucfirst=>{}, @newnodes] : ();
      
    },
  },
  help => {
    OutProcess => sub {
      my ($sx, $viewer, $recursor) = @_;
      # yes, we're returning the same element.
      return [help=>{
        %{$sx->[SX_ATTR]}, 
        "xlink:type"=>"simple",
        "xlink:href"=>"/help?".join('',@{$sx}[SX_CONT..$#$sx]),
      },$recursor->(@{$sx}[SX_CONT..$#$sx])];
    },
  },
  'html:pre' => {
    OutProcess => sub {
      my ($sx, $viewer, $recursor) = @_;
      return ['html:pre', {'xml:space' => 'preserve', %{$sx->[SX_ATTR]}}, $recursor->(@{$sx}[SX_CONT..$#$sx])];
    },
  },
  'ipre' => {
    OutProcess => sub {
      my ($sx, $viewer, $recursor) = @_;
      return ['ipre', {'xml:space' => 'preserve', %{$sx->[SX_ATTR]}}, $recursor->(@{$sx}[SX_CONT..$#$sx])];
    },
  },
  if => {
    OutProcess => sub {
      my ($sx, $viewer, $recursor) = @_;
      my %elem;
      for (@$sx[SX_CONT..$#$sx]) {
        next unless ref() and ref() eq 'ARRAY';
        $elem{$_->[SX_ELEM]} = $_;
      }
      my $test = $elem{test} or return "[ERROR: No condition]";
      my $result = sx2xml(map $recursor->($_), @$test[SX_CONT..$#$test]);
      #mudlog "DEBUG: if '$result' chose " . ($result ? 'then' : 'else');
      my $pick = $elem{$result ? 'then' : 'else'} or return ();
      return map $recursor->($_), @$pick[SX_CONT..$#$pick];
    },
  },
  obj => {
    OutProcess => sub {
      my ($sx, $viewer, $recursor, $con) = @_;
      my $obj;
      if (blessed($sx->[SX_CONT], 'MObjectRef')) {
        $obj = $sx->[SX_CONT];
      } elsif (my $id = $sx->[SX_ATTR]{'oid'}) {
        $id =~ /^(\d+)$/ or return "[ERROR: NON-NUMERIC ID]";
        $obj = ObjectByID($id) or return "[MISSING]";
      } elsif (exists $sx->[SX_ATTR]{'viewer'}) {
        $obj = $viewer;
      } else {
        # if there's no object we can find, then it's literal text and we return it
        return [@$sx[SX_ELEM..SX_ATTR], map $recursor->($_), @$sx[SX_CONT..$#$sx]];
      }
      $viewer or return "[ERROR: No viewpoint]";
      my $part = $sx->[SX_ATTR]{part} || 'nphr';
      my $is = $con->pref('viewpoint') < 3 && $obj->id == $viewer->id;
      
      my @oattr = (
        "xlink:type"=>"simple",
        "xlink:href"=>"/look?".$obj->name, # FIXME: proper URL, proper escaping
      );
      
      my $case = $part =~ s/^(.+)-// ? $1 : 'o';
      
      if ($part eq 'nphr')       {my $a = (grep {$_->id == $obj->id} @{$viewer->last_mentioned_object}) ? 'the' : undef; 
                                  return [obj=>{@oattr}, $pick_pronoun->($con, $viewer, $obj, $case)] if $a and @{$viewer->last_mentioned_object} == 1;
                                  return [obj=>{@oattr}, ($is ? $pick_pronoun->($con, $viewer, $obj, $case) : $viewer->can_see($obj) ? $obj->nphr($a)               : 'something')  ]}
      elsif ($part eq 'name')    {return [obj=>{@oattr}, $viewer->can_see($obj) ? $obj->getAttr('name') : 'something'  ]}
      elsif ($part eq 'idn')     {return [obj=>{@oattr}, [quo=>{}, '#'], $obj->id, ' ', $obj->nphr]}
      elsif ($part eq 'poss')    {return [obj=>{@oattr}, ($is ? 'your' : $viewer->can_see($obj) ? ($obj->getAttr('name')."'s") : "something's")]}
      elsif ($part eq 'pron')    {return $pick_pronoun->($con, $viewer, $obj, $case)}
      elsif ($part eq 'spron')   {return $pick_pronoun->($con, $viewer, $obj, 's')}
      elsif ($part eq 'opron')   {return $pick_pronoun->($con, $viewer, $obj, 'o')}
      elsif ($part eq 'ppron')   {return $pick_pronoun->($con, $viewer, $obj, 'p')}
      elsif ($part eq 'prep')    {return $obj->getAttr('enter_prep')}
      elsif ($part eq 'is')      {return (exists $sx->[SX_ATTR]{data} ? sx2xml($recursor->($sx->[SX_ATTR]{data})) eq $obj->id : $obj->id == $viewer->id) ? 1 : 0}
      elsif ($part eq 'vis')     {return ($viewer->can_see ($obj)) ? 1 : 0}
      elsif ($part eq 'aud')     {return ($viewer->can_hear($obj)) ? 1 : 0}
      elsif ($part eq 'nphr_details') {
        my @a = (grep {$_->id == $obj->id} @{$viewer->last_mentioned_object}) ? ('the') : (); 

        my $inside;
        if (!$sx->[SX_ATTR]{no_substitution} and $obj->glance_contents
            and (my @vis_cont = grep $viewer->can_see($_), @{$obj->contents}) == 1
        ) {
          $inside = $obj;
          $obj = $vis_cont[0];
        }
  	my $flstr = (''
          . ( MConnection->obj_connections($obj)  ? ' (connected)' : '')
          . ( $obj->invisible                     ? ' (invisible)' : '')
	);
        return (
          [obj=>{@oattr}, ($is ? 'you' : $viewer->can_see($obj) ? $obj->nphr(@a) : 'something'), $flstr],
          ($inside ? (' ' . $inside->enter_prep . ' ', $recursor->([obj=>{part=>'nphr_details',no_substitution=>1},$inside])) : ())
        );
      }
      else { return "[ERROR: bad part: '$part']"}
    },
  },
  verb => {
    OutProcess => sub {
      my ($sx, $viewer, $recursor, $con) = @_;
      my $subj = $sx->[SX_ATTR]{'subj'};
      return $con->pref('viewpoint') < 3 && ($subj eq 'viewer' or $subj->id == $viewer->id)
        ? Lingua::EN::Inflect::PL_V($sx->[SX_ATTR]{'s'})
        : $sx->[SX_ATTR]{'s'};
    },
  },
  
  li => { KeepEmpty => 1 },
  division => { KeepEmpty => 1 },
};
###############################################################################

Define Methods => {
#------------------------------------------------------------------------------
nphr => sub {
  my ($self, $article) = @_;
  my $a;
  if ($a = $self->getAttr('article')) {
    $a = $article if $article;
    $a .= ' ';
  } else {
    $a = '';
  }
  return $a . $self->name;
},
#------------------------------------------------------------------------------
sact => sub {
  my ($self, $thing, @objs) = @_;
  
  my %seen;
  foreach ($self, @objs) {
    $_->object_scan(sub {
      my ($o) = @_;
      return if $seen{$o->id}++;
      $o->send($thing);
      0;
    });
  }
  return;
},
#------------------------------------------------------------------------------
nact => sub {
  my ($self, $desc, %objs) = @_;
  
  $self->sact([action=>{}, [ucfirst=>{}, desc_gen($desc, %objs, self => $self)]], values %objs);
},
#------------------------------------------------------------------------------
dg_send => sub {
  my $self = shift;
  $self->send([ucfirst=>{}, desc_gen(@_)]);
  return;
},
#------------------------------------------------------------------------------
};
###############################################################################
Define Subs => {
#------------------------------------------------------------------------------
desc_gen => sub {
  my ($str, %objs) = @_;

  return wantarray ?             $dg_parser->(\$str, '', \%objs, {})
                   : [group=>{}, $dg_parser->(\$str, '', \%objs, {})];
},
#------------------------------------------------------------------------------
dg_escape => sub {
  my $str = $_[0];
  $str =~ s/([<>:])/'<e:#' . ord($1) . '>'/eg;
  $str;
},
#------------------------------------------------------------------------------
},