use strict;
Require 'connections', 'commands';

my $data = Etc('whorecent_data', {initial => {}, log => []});

my $pushrec = sub {
  my ($uname, $change) = @_;
  push @{$data->{log}}, {user=>$uname, change=>$change, time=>MScheduler->realclock()};
  unless (@{$data->{log}} < 10) {
    my $oldrecord = shift @{$data->{log}};
    $data->{initial}{$oldrecord->{user}} += $oldrecord->{change};
    delete $data->{initial}{$oldrecord->{user}} if $data->{initial}{$oldrecord->{user}} == 0;
  }
};

my $wrecent_gen = sub {
  my ($con, $args, %info) = @_;

  ### Input data
  
  my @log = @{$data->{log}};
  my %users_and_initial = %{$data->{initial}};
  for (@log) {
    $users_and_initial{$_->{user}} ||= 0;
  }
  
  my $available_width = $con->pref('scr_width') || 80;
  my $t24hour = $info{opt_24};
  
  ### setup
  
  my $t_start = MScheduler->realclock - ($args || 24) * 3600;
  $t_start = $log[0]{'time'} if $log[0]{'time'} > $t_start;
  my $t_range = int(MScheduler->realclock) - $t_start;
  #$con->send("start $t_start range $t_range");
  
  my $wid_user = 0;
  for (map length, keys %users_and_initial) {$wid_user = $_ if $_ > $wid_user}
  
  my $wid_chart = $available_width - $wid_user - 3;
  my $fmt = "%${wid_user}s >%${wid_chart}s>\n";
  
  my $show_minutes = $t_range < 3*60*60;
  my $show_seconds = $t_range < 3*60;
  
  # similar to code in &$pushrec
  while (@log and $log[0]{'time'} < $t_start) {
    my $oldrecord = shift @log;
    $users_and_initial{$oldrecord->{user}} += $oldrecord->{change};
  }
  
  ### compute data
  
  my $timeline = ' ' x $wid_chart;
  my $prevstr = '';
  
  my %state = map +($_, $users_and_initial{$_} || 0), keys %users_and_initial;
  my %chart = map +($_, ''), keys %users_and_initial;
  
  for (my $char = 0; $char < $wid_chart; $char++) {
    my $time = $t_start + $char * ($t_range / $wid_chart);
   
    # put time in title line
    {
      (my $sec, my $min, my $hour) = MScheduler->clock_localtime($time);
      #$con->send("char $char time $time $hour:$min:$sec");
  
      my $min_str = ($show_minutes ? sprintf(":%02u", $min) : '')
                  . ($show_seconds ? sprintf(":%02u", $sec) : '');
  
      my $time_str = $t24hour
	? $hour . $min_str
	: ($hour % 12 || 12) . $min_str . (int($hour / 12) ? 'p' : 'a');
  
      substr($timeline, $char, length $time_str) = $prevstr = $time_str
	if $time_str ne $prevstr and
	 substr($timeline, $char-1, 1) eq ' '; 
    }
  
    my %changed;
  
    # change state character
    while ($log[0] and $log[0]{'time'} < $time) {
      my $record = shift @log;
      $state{$record->{user}} += $record->{change};
      $changed{$record->{user}}++;
    }
  
    # add state character to line
    for (keys %users_and_initial) {
      $chart{$_} .= ($changed{$_} || 0) > 1 ? '*' : $state{$_} ? '#' : '-';
    }
    
  }
  for (grep $chart{$_} !~ /.+[^-]/, keys %users_and_initial) {
    #mudlog "didn't match $_ $chart{$_}";
    delete $users_and_initial{$_};
  }

  return [report=>{},
    [title=>{},"Users' recent activity ('-' absent, '#' present, '*' both)"],
    ['html:pre',{}, 
        sprintf($fmt, '', substr($timeline, 0, $wid_chart))
      . join('', map sprintf($fmt, $_, $chart{$_}), sort keys %users_and_initial)

    ],
  ];
};

Define Hooks => {
'user_active' => sub {
  my ($uname, $con) = @_;
  $pushrec->($uname, +1);
},
'user_inactive' => sub {
  my ($uname, $con) = @_;
  $pushrec->($uname, -1);
},
};

Define Commands => {
who => {
  no_object => 1,
  code => sub {
    my ($con, $args, %info) = @_;
  
    goto &$wrecent_gen if $info{opt_r} or $info{opt_recent};
  
    my @connections = sort {$b->id <=> $a->id} MConnection->all;
  
    return [report=>{},
      [title=>{},"Users currently connected"],
      ['html:ul',{'html:class'=>'report'}, 
        map {
          my $user = $_->user;
          (!$user and $_->state !~ /command|talk/) ? () : (['html:li',{},
            !$user ? (
              'Guest ' . $_->id
            ) : (
              (
                $user->name, [user=>{}, ($user->get('title') || '')],
                (scalar keys %{$user->get('privileges') || {}} ? ' (P)' : '')
              )
            ),
            ($_->idle_time > 60*5 ? ' (Idle ' . format_time($_->idle_time) . ')' : ''),
            ($_->id == $con->id ? ' (you)' : ()),
          ]);
        } @connections
      ],
      ((@connections < 4 and $con->pref('advice') >= 3) ? (['html:p'=>{}], ['html:p'=>{},
        'Hint: You can type "who /recent" to see who\'s been connected recently, instead of right now.',
      ]) : ()),
    ];
  }, 
  help => [group=>{},
    ['html:p'=>{},'Lists all users currently connected.'],
    ['html:p'=>{},'If the -r[ecent] option is specified, displays a chart of recent user activity. Default time period is one day, or you can specify a time period in hours.'],
  ],
},
};
