package MConnection::Capturing;
use strict;
use vars qw(
  @ISA
);
@ISA = qw(MConnection);

sub _subnew {
  my ($self) = @_;
  $self->{captured} = '';
}

sub send_str_raw {
  my ($self, $text) = @_;
  $self->{captured} .= $text;
}

sub id_log {}

sub disconnect {
  my $self = shift;
  
  if ($self->terminal) {
    # make sure terminal wraps up
    $self->terminal(undef);
  }

  my $capt = $self->{captured};
  $self->SUPER::disconnect(@_);
  return $capt;
}

sub source {"capture"}
sub captured {return $_[0]{captured}}

1;
