package MConnection::Nil;
use strict;
use vars qw(@ISA $Stale);
@ISA = qw(MConnection);

use integer;
use MCoreTools;

$Stale = 0 unless defined $Stale;

### Object methods - creation/destruction ##########################################################################################

sub now_nil {
  $Stale++;
}

sub disconnect {
  my ($self, $desc, $iserror) = @_;

  mudlog "ERROR/CORE: Disconnected already disconnected connection ($desc)";
}

sub DESTROY {
  mudlog "DEBUG: Nil connection #$_[0]->{id}, formerly $_[0]->{formerly}, disposed. " . Data::Dumper::Dumper($_[0]) unless $::Quit eq 'no_cleanup';
  $Stale--;
}

### Object methods - Stuff to be overridden ##########################################################################################

sub _subnew {}

sub open {0}

### Object methods - Other ##########################################################################################

sub source {'nil'}

sub id         {$_[0]{id}}

sub idle_time {0}

sub is_nil {1}

sub AUTOLOAD {
  use vars '$AUTOLOAD';
  mudlog "WARNING: $AUTOLOAD called, creating no-op subroutine";
  no strict 'refs';
  *$AUTOLOAD = sub {return ()};
}

1;
