#!/usr/bin/perl -w
use strict;
use Test;
use Mud::Freezer;
use Data::Dumper;

BEGIN { plan test => 2 + 9 * keys(%Mud::Freezer::AVAIL); }

# load ok
ok 1;

ok scalar keys %Mud::Freezer::AVAIL;

for my $mode (keys %Mud::Freezer::AVAIL) {
  print "# $mode\n";
  # poking around in internal structures...
  # but we need to test every available thawing
  local $Mud::Freezer::USE = $mode;

  # basic test of freeze/thaw
  {
    my $foo = \"foo";
    my $restored = Mud::Freezer::thaw(Mud::Freezer::freeze($foo));
    ok ref $restored, 'SCALAR';
    ok $$restored eq $$foo if ref $restored eq 'SCALAR';
  }
  
  # cloning ok?
  ok ${\42}, ${Mud::Freezer::clone(\42)};
  
  # objectish interface works?
  ok ${\42}, ${Mud::Freezer->thaw(Mud::Freezer->freeze(\42))};
  
  # can load Dumper frozens?
  ok "foo" eq Mud::Freezer::thaw('Dumpr$VAR1="foo";');
  
  # handles weird chars in strings?
  {
    my $foo = \"The quick \x00 brown \x01 fox \xFF\xC2 jumped over the lazy dog.\x00";
    ok $$foo eq ${Mud::Freezer::thaw(Mud::Freezer::freeze($foo))};
  }
  
  # handles weird values in data structures?
  {
    my $structure = { foo => [1,'two',3,undef], bar => {'' => 24} };
    ok Dumper(Mud::Freezer::thaw(Mud::Freezer::freeze($structure))), Dumper($structure);
    ok Dumper(Mud::Freezer::clone($structure)),                      Dumper($structure);
  }
  
  # handles recursive structures?
  {
    my $structure = [];
    push @$structure, $structure;
    ok Dumper($structure) eq Dumper(Mud::Freezer::clone($structure));
  
    pop @$structure; # prevent leak
  }
}

# FIXME: need to test file-IO routines
