#!/usr/bin/perl -w
use strict;
use Test;
BEGIN { plan test => 9; }

use Mud::Obj::Attributed;
my $the_class = 'Mud::Obj::Attributed';

my $thing = $the_class->new;
ok defined $thing;
ok $thing->isa($the_class);

ok not defined $thing->getAttribute('someNS', 'someAttribute');
$thing->setAttribute('someNS', 'someAttribute', 'someValue');
ok $thing->getAttribute('someNS', 'someAttribute', 'someValue');

ok not defined $thing->getAttr('someAttribute');
$thing->setAttr('someAttribute', 'someValue');
ok $thing->getAttr('someAttribute', 'someValue');

#use Data::Dumper;
#print Data::Dumper::Dumper($thing);

ok $thing->listAttributes('someNS'), 1, "listAttributes('someNS')";
ok $thing->listAttributes(''), 1, "listAttributes('')";
ok $thing->listNamespaces(), 2, "listNamespaces()";
